/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities.hansen;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenUtilities;

public class FieldHansenZonalLinear<T extends CalculusFieldElement<T>> {
    private static final int SLICE = 10;
    private final PolynomialFunction[][] mpvec;
    private final PolynomialFunction[][] mpvecDeriv;
    private final T[][] hansenRoot;
    private final T[][] hansenDerivRoot;
    private final int s;
    private final int offset;
    private final int numSlices;
    private final double twots;
    private final int twosp1;
    private final int twos;
    private final double twosp1otwots;

    public FieldHansenZonalLinear(int nMax, int s, Field<T> field) {
        int Nmin = -nMax - 1;
        int N0 = -(s + 2);
        this.offset = nMax + 1;
        this.s = s;
        this.twots = FastMath.pow((double)2.0, (int)s);
        this.twos = 2 * s;
        this.twosp1 = this.twos + 1;
        this.twosp1otwots = (double)this.twosp1 / this.twots;
        int size = nMax - s - 1;
        this.mpvec = new PolynomialFunction[size][];
        this.mpvecDeriv = new PolynomialFunction[size][];
        this.numSlices = FastMath.max((int)((int)FastMath.ceil((double)((double)size / 10.0))), (int)1);
        this.hansenRoot = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)this.numSlices, (int)2);
        this.hansenDerivRoot = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)this.numSlices, (int)2);
        HansenUtilities.generateZonalPolynomials(N0, Nmin, this.offset, 10, s, this.mpvec, this.mpvecDeriv);
    }

    public void computeInitValues(T chi) {
        Field field = chi.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        this.hansenRoot[0][0] = zero;
        this.hansenRoot[0][1] = (CalculusFieldElement)FastMath.pow(chi, (int)this.twosp1).divide(this.twots);
        this.hansenDerivRoot[0][0] = zero;
        this.hansenDerivRoot[0][1] = (CalculusFieldElement)FastMath.pow(chi, (int)this.twos).multiply(this.twosp1otwots);
        int st = -this.s - 1;
        for (int i = 1; i < this.numSlices; ++i) {
            for (int j = 0; j < 2; ++j) {
                PolynomialFunction[] mv = this.mpvec[st - i * 10 - j + this.offset];
                PolynomialFunction[] sv = this.mpvecDeriv[st - i * 10 - j + this.offset];
                this.hansenDerivRoot[i][j] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mv[1].value(chi).multiply(this.hansenDerivRoot[i - 1][1])).add((FieldElement)((CalculusFieldElement)mv[0].value(chi).multiply(this.hansenDerivRoot[i - 1][0])))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sv[1].value(chi).multiply(this.hansenRoot[i - 1][1])).add((FieldElement)((CalculusFieldElement)sv[0].value(chi).multiply(this.hansenRoot[i - 1][0])))).divide(chi)));
                this.hansenRoot[i][j] = (CalculusFieldElement)((CalculusFieldElement)mv[1].value(chi).multiply(this.hansenRoot[i - 1][1])).add((FieldElement)((CalculusFieldElement)mv[0].value(chi).multiply(this.hansenRoot[i - 1][0])));
            }
        }
    }

    public T getValue(int mnm1, T chi) {
        int n = -mnm1 - 1;
        int sliceNo = (n - this.s) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n - this.s) % 10;
            if (indexInSlice <= 1) {
                return this.hansenRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[mnm1 + this.offset];
        CalculusFieldElement ret = (CalculusFieldElement)v[1].value(chi).multiply(this.hansenRoot[sliceNo][1]);
        if (this.hansenRoot[sliceNo][0].getReal() != 0.0) {
            ret = (CalculusFieldElement)ret.add((FieldElement)((CalculusFieldElement)v[0].value(chi).multiply(this.hansenRoot[sliceNo][0])));
        }
        return (T)ret;
    }

    public T getDerivative(int mnm1, T chi) {
        int n = -mnm1 - 1;
        int sliceNo = (n - this.s) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n - this.s) % 10;
            if (indexInSlice <= 1) {
                return this.hansenDerivRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[mnm1 + this.offset];
        CalculusFieldElement ret = (CalculusFieldElement)v[1].value(chi).multiply(this.hansenDerivRoot[sliceNo][1]);
        if (this.hansenDerivRoot[sliceNo][0].getReal() != 0.0) {
            ret = (CalculusFieldElement)ret.add((FieldElement)((CalculusFieldElement)v[0].value(chi).multiply(this.hansenDerivRoot[sliceNo][0])));
        }
        PolynomialFunction[] v1 = this.mpvecDeriv[mnm1 + this.offset];
        CalculusFieldElement hret = (CalculusFieldElement)v1[1].value(chi).multiply(this.hansenRoot[sliceNo][1]);
        if (this.hansenRoot[sliceNo][0].getReal() != 0.0) {
            hret = (CalculusFieldElement)hret.add((FieldElement)((CalculusFieldElement)v1[0].value(chi).multiply(this.hansenRoot[sliceNo][0])));
        }
        ret = (CalculusFieldElement)ret.add((FieldElement)((CalculusFieldElement)hret.divide(chi)));
        return (T)ret;
    }
}

