/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities.hansen;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenUtilities;

public class FieldHansenThirdBodyLinear<T extends CalculusFieldElement<T>> {
    private static final int SLICE = 10;
    private final PolynomialFunction[][] mpvec;
    private final PolynomialFunction[][] mpvecDeriv;
    private final T[][] hansenRoot;
    private final T[][] hansenDerivRoot;
    private final int numSlices;
    private final int s;
    private double twosp1dfosp1f;
    private final double twosp1dfosp2f;
    private final double two2sp1dfosp2f;
    private final double twosp3;

    public FieldHansenThirdBodyLinear(int nMax, int s, Field<T> field) {
        this.s = s;
        this.twosp1dfosp1f = s % 2 == 0 ? 1.0 : -1.0;
        for (int i = s; i >= 1; --i) {
            this.twosp1dfosp1f *= (2.0 * (double)i + 1.0) / ((double)i + 1.0);
        }
        this.twosp1dfosp2f = this.twosp1dfosp1f / ((double)s + 2.0);
        this.twosp3 = 2 * s + 3;
        this.two2sp1dfosp2f = 2.0 * this.twosp1dfosp2f;
        this.mpvec = new PolynomialFunction[nMax + 1][];
        this.mpvecDeriv = new PolynomialFunction[nMax + 1][];
        this.numSlices = FastMath.max((int)1, (int)((nMax - s + 10 - 2) / 10));
        this.hansenRoot = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)this.numSlices, (int)2);
        this.hansenDerivRoot = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)this.numSlices, (int)2);
        HansenUtilities.generateThirdBodyPolynomials(s, nMax, 10, s, this.mpvec, this.mpvecDeriv);
    }

    public void computeInitValues(T chitm1, T chitm2, T chitm3) {
        Field field = chitm2.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        this.hansenRoot[0][0] = (CalculusFieldElement)zero.newInstance(this.twosp1dfosp1f);
        this.hansenRoot[0][1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)chitm2.negate()).add(this.twosp3)).multiply(this.twosp1dfosp2f);
        this.hansenDerivRoot[0][0] = zero;
        this.hansenDerivRoot[0][1] = (CalculusFieldElement)chitm3.multiply(this.two2sp1dfosp2f);
        for (int i = 1; i < this.numSlices; ++i) {
            for (int j = 0; j < 2; ++j) {
                PolynomialFunction[] mv = this.mpvec[this.s + i * 10 + j];
                PolynomialFunction[] sv = this.mpvecDeriv[this.s + i * 10 + j];
                this.hansenDerivRoot[i][j] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mv[1].value(chitm1).multiply(this.hansenDerivRoot[i - 1][1])).add((FieldElement)((CalculusFieldElement)mv[0].value(chitm1).multiply(this.hansenDerivRoot[i - 1][0])))).add((FieldElement)((CalculusFieldElement)sv[1].value(chitm1).multiply(this.hansenRoot[i - 1][1])))).add((FieldElement)((CalculusFieldElement)sv[0].value(chitm1).multiply(this.hansenRoot[i - 1][0])));
                this.hansenRoot[i][j] = (CalculusFieldElement)((CalculusFieldElement)mv[1].value(chitm1).multiply(this.hansenRoot[i - 1][1])).add((FieldElement)((CalculusFieldElement)mv[0].value(chitm1).multiply(this.hansenRoot[i - 1][0])));
            }
        }
    }

    public T getValue(int n, T chitm1) {
        int sliceNo = (n - this.s) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n - this.s) % 10;
            if (indexInSlice <= 1) {
                return this.hansenRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[n];
        CalculusFieldElement ret = (CalculusFieldElement)v[1].value(chitm1).multiply(this.hansenRoot[sliceNo][1]);
        if (this.hansenRoot[sliceNo][0].getReal() != 0.0) {
            ret = (CalculusFieldElement)ret.add((FieldElement)((CalculusFieldElement)v[0].value(chitm1).multiply(this.hansenRoot[sliceNo][0])));
        }
        return (T)ret;
    }

    public T getDerivative(int n, T chitm1) {
        int sliceNo = (n - this.s) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n - this.s) % 10;
            if (indexInSlice <= 1) {
                return this.hansenDerivRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[n];
        CalculusFieldElement ret = (CalculusFieldElement)v[1].value(chitm1).multiply(this.hansenDerivRoot[sliceNo][1]);
        if (this.hansenDerivRoot[sliceNo][0].getReal() != 0.0) {
            ret = (CalculusFieldElement)ret.add((FieldElement)((CalculusFieldElement)v[0].value(chitm1).multiply(this.hansenDerivRoot[sliceNo][0])));
        }
        PolynomialFunction[] v1 = this.mpvecDeriv[n];
        ret = (CalculusFieldElement)ret.add((FieldElement)((CalculusFieldElement)v1[1].value(chitm1).multiply(this.hansenRoot[sliceNo][1])));
        if (this.hansenRoot[sliceNo][0].getReal() != 0.0) {
            ret = (CalculusFieldElement)ret.add((FieldElement)((CalculusFieldElement)v1[0].value(chitm1).multiply(this.hansenRoot[sliceNo][0])));
        }
        return (T)ret;
    }
}

