/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.util.FastMath;

public class NewcombOperators {
    private static final Map<NewKey, Double> MAP = new TreeMap<NewKey, Double>((k1, k2) -> {
        if (((NewKey)k1).n == ((NewKey)k2).n) {
            if (((NewKey)k1).s == ((NewKey)k2).s) {
                if (((NewKey)k1).rho == ((NewKey)k2).rho) {
                    return Integer.compare(((NewKey)k1).sigma, ((NewKey)k2).sigma);
                }
                if (((NewKey)k1).rho < ((NewKey)k2).rho) {
                    return -1;
                }
                return 1;
            }
            if (((NewKey)k1).s < ((NewKey)k2).s) {
                return -1;
            }
            return 1;
        }
        if (((NewKey)k1).n < ((NewKey)k2).n) {
            return -1;
        }
        return 1;
    });

    private NewcombOperators() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getValue(int rho, int sigma, int n, int s) {
        NewKey key = new NewKey(n, s, rho, sigma);
        Map<NewKey, Double> map = MAP;
        synchronized (map) {
            if (MAP.containsKey(key)) {
                return MAP.get(key);
            }
        }
        List polynomials = PolynomialsGenerator.getPolynomials(rho, sigma);
        double nPower = 1.0;
        double value = 0.0;
        for (PolynomialFunction polynomial : polynomials) {
            value += polynomial.value((double)s) * nPower;
            nPower = (double)n * nPower;
        }
        Map<NewKey, Double> map2 = MAP;
        synchronized (map2) {
            MAP.put(key, value);
        }
        return value;
    }

    private static class NewKey {
        private final int n;
        private final int s;
        private final int rho;
        private final int sigma;

        NewKey(int n, int s, int rho, int sigma) {
            this.n = n;
            this.s = s;
            this.rho = rho;
            this.sigma = sigma;
        }
    }

    private static class Couple {
        private final int rho;
        private final int sigma;

        private Couple(int rho, int sigma) {
            this.rho = rho;
            this.sigma = sigma;
        }
    }

    private static class PolynomialsGenerator {
        private static final SortedMap<Couple, List<PolynomialFunction>> POLYNOMIALS = new TreeMap<Couple, List<PolynomialFunction>>((c1, c2) -> {
            if (((Couple)c1).rho == ((Couple)c2).rho) {
                if (((Couple)c1).sigma < ((Couple)c2).sigma) {
                    return -1;
                }
                if (((Couple)c1).sigma == ((Couple)c2).sigma) {
                    return 0;
                }
            } else if (((Couple)c1).rho < ((Couple)c2).rho) {
                return -1;
            }
            return 1;
        });

        private PolynomialsGenerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static List<PolynomialFunction> getPolynomials(int rho, int sigma) {
            Couple couple = new Couple(rho, sigma);
            SortedMap<Couple, List<PolynomialFunction>> sortedMap = POLYNOMIALS;
            synchronized (sortedMap) {
                if (POLYNOMIALS.isEmpty()) {
                    ArrayList<PolynomialFunction> l00 = new ArrayList<PolynomialFunction>();
                    ArrayList<PolynomialFunction> l01 = new ArrayList<PolynomialFunction>();
                    ArrayList<PolynomialFunction> l10 = new ArrayList<PolynomialFunction>();
                    ArrayList<PolynomialFunction> l11 = new ArrayList<PolynomialFunction>();
                    l00.add(new PolynomialFunction(new double[]{1.0}));
                    l01.add(new PolynomialFunction(new double[]{0.0, -1.0}));
                    l01.add(new PolynomialFunction(new double[]{-0.5}));
                    l10.add(new PolynomialFunction(new double[]{0.0, 1.0}));
                    l10.add(new PolynomialFunction(new double[]{-0.5}));
                    l11.add(new PolynomialFunction(new double[]{1.5, 0.0, -1.0}));
                    l11.add(new PolynomialFunction(new double[]{1.25}));
                    l11.add(new PolynomialFunction(new double[]{0.25}));
                    POLYNOMIALS.put(new Couple(0, 0), l00);
                    POLYNOMIALS.put(new Couple(0, 1), l01);
                    POLYNOMIALS.put(new Couple(1, 0), l10);
                    POLYNOMIALS.put(new Couple(1, 1), l11);
                }
                if (!POLYNOMIALS.containsKey(couple)) {
                    PolynomialsGenerator.computeFor(rho, sigma);
                }
                return (List)POLYNOMIALS.get(couple);
            }
        }

        private static void computeFor(int rho, int sigma) {
            List<PolynomialFunction> list;
            List<PolynomialFunction> poly;
            List<Object> result = new ArrayList();
            Map<Integer, List<PolynomialFunction>> map = PolynomialsGenerator.generateRecurrenceCoefficients(rho, sigma);
            if (rho >= 2) {
                poly = map.get(0);
                list = PolynomialsGenerator.getPolynomials(rho - 2, sigma);
                result = PolynomialsGenerator.multiplyPolynomialList(poly, PolynomialsGenerator.shiftList(list, 2));
            }
            if (rho >= 1 && sigma >= 1) {
                poly = map.get(1);
                list = PolynomialsGenerator.getPolynomials(rho - 1, sigma - 1);
                result = PolynomialsGenerator.sumPolynomialList(result, PolynomialsGenerator.multiplyPolynomialList(poly, list));
            }
            if (rho >= 1) {
                poly = map.get(2);
                list = PolynomialsGenerator.getPolynomials(rho - 1, sigma);
                result = PolynomialsGenerator.sumPolynomialList(result, PolynomialsGenerator.multiplyPolynomialList(poly, PolynomialsGenerator.shiftList(list, 1)));
            }
            if (sigma >= 2) {
                poly = map.get(3);
                list = PolynomialsGenerator.getPolynomials(rho, sigma - 2);
                result = PolynomialsGenerator.sumPolynomialList(result, PolynomialsGenerator.multiplyPolynomialList(poly, PolynomialsGenerator.shiftList(list, -2)));
            }
            if (sigma >= 1) {
                poly = map.get(4);
                list = PolynomialsGenerator.getPolynomials(rho, sigma - 1);
                result = PolynomialsGenerator.sumPolynomialList(result, PolynomialsGenerator.multiplyPolynomialList(poly, PolynomialsGenerator.shiftList(list, -1)));
            }
            Couple couple = new Couple(rho, sigma);
            POLYNOMIALS.put(couple, result);
        }

        private static List<PolynomialFunction> multiplyPolynomialList(List<PolynomialFunction> poly1, List<PolynomialFunction> poly2) {
            ArrayList<PolynomialFunction> result = new ArrayList<PolynomialFunction>();
            PolynomialsGenerator.initializeListOfPolynomials(poly1.size() + poly2.size() - 1, result);
            int i = 0;
            for (PolynomialFunction f1 : poly1) {
                for (int j = i; j < poly2.size() + i; ++j) {
                    PolynomialFunction p2 = poly2.get(j - i);
                    PolynomialFunction previousP2 = (PolynomialFunction)result.get(j);
                    result.set(j, previousP2.add(f1.multiply(p2)));
                }
                ++i;
            }
            return result;
        }

        private static List<PolynomialFunction> sumPolynomialList(List<PolynomialFunction> poly1, List<PolynomialFunction> poly2) {
            int i;
            int lowLength = FastMath.min((int)poly1.size(), (int)poly2.size());
            int highLength = FastMath.max((int)poly1.size(), (int)poly2.size());
            ArrayList<PolynomialFunction> result = new ArrayList<PolynomialFunction>();
            PolynomialsGenerator.initializeListOfPolynomials(highLength, result);
            for (i = 0; i < lowLength; ++i) {
                result.set(i, poly1.get(i).add(poly2.get(i)));
            }
            for (i = lowLength; i < highLength; ++i) {
                if (poly1.size() < poly2.size()) {
                    result.set(i, poly2.get(i));
                    continue;
                }
                result.set(i, poly1.get(i));
            }
            return result;
        }

        private static void initializeListOfPolynomials(int i, List<PolynomialFunction> result) {
            for (int k = 0; k < i; ++k) {
                result.add(new PolynomialFunction(new double[]{0.0}));
            }
        }

        private static List<PolynomialFunction> shiftList(List<PolynomialFunction> polynomialList, int shift) {
            ArrayList<PolynomialFunction> shiftedList = new ArrayList<PolynomialFunction>();
            for (PolynomialFunction function : polynomialList) {
                shiftedList.add(new PolynomialFunction(PolynomialsGenerator.shift(function.getCoefficients(), shift)));
            }
            return shiftedList;
        }

        public static double[] shift(double[] coefficients, double shift) {
            int dp1 = coefficients.length;
            double[] newCoefficients = new double[dp1];
            double[][] coeff = new double[dp1][dp1];
            coeff[0][0] = 1.0;
            for (int i = 1; i < dp1; ++i) {
                coeff[i][0] = 1.0;
                for (int j = 1; j < i; ++j) {
                    coeff[i][j] = coeff[i - 1][j - 1] + coeff[i - 1][j];
                }
                coeff[i][i] = 1.0;
            }
            double shiftI = 1.0;
            for (double coefficient : coefficients) {
                newCoefficients[0] = newCoefficients[0] + coefficient * shiftI;
                shiftI *= shift;
            }
            int d = dp1 - 1;
            for (int i = 0; i < d; ++i) {
                double shiftJmI = 1.0;
                for (int j = i; j < d; ++j) {
                    int n = i + 1;
                    newCoefficients[n] = newCoefficients[n] + coeff[j + 1][j - i] * coefficients[j + 1] * shiftJmI;
                    shiftJmI *= shift;
                }
            }
            return newCoefficients;
        }

        private static Map<Integer, List<PolynomialFunction>> generateRecurrenceCoefficients(int rho, int sigma) {
            double den = 1.0 / (4.0 * (double)(rho + sigma));
            double denx2 = 2.0 * den;
            double denx4 = 4.0 * den;
            TreeMap<Integer, List<PolynomialFunction>> list = new TreeMap<Integer, List<PolynomialFunction>>();
            ArrayList<PolynomialFunction> poly0 = new ArrayList<PolynomialFunction>();
            ArrayList<PolynomialFunction> poly1 = new ArrayList<PolynomialFunction>();
            ArrayList<PolynomialFunction> poly2 = new ArrayList<PolynomialFunction>();
            ArrayList<PolynomialFunction> poly3 = new ArrayList<PolynomialFunction>();
            ArrayList<PolynomialFunction> poly4 = new ArrayList<PolynomialFunction>();
            poly0.add(new PolynomialFunction(new double[]{0.0, den}));
            poly0.add(new PolynomialFunction(new double[]{-den}));
            poly1.add(new PolynomialFunction(new double[]{1.0 + denx4}));
            poly1.add(new PolynomialFunction(new double[]{denx2 + denx4}));
            poly2.add(new PolynomialFunction(new double[]{0.0, denx4}));
            poly2.add(new PolynomialFunction(new double[]{-denx2}));
            poly3.add(new PolynomialFunction(new double[]{0.0, -den}));
            poly3.add(new PolynomialFunction(new double[]{-den}));
            poly4.add(new PolynomialFunction(new double[]{0.0, -denx4}));
            poly4.add(new PolynomialFunction(new double[]{-denx2}));
            list.put(0, poly0);
            list.put(1, poly1);
            list.put(2, poly2);
            list.put(3, poly3);
            list.put(4, poly4);
            return list;
        }
    }
}

