/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.SortedMap;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;

public class LnsCoefficients {
    private final double[][] lns;
    private final double[][] dlns;

    public LnsCoefficients(int nMax, int sMax, double[][] Qns, SortedMap<CoefficientsFactory.NSKey, Double> Vns, double roa) {
        int rows = nMax + 1;
        int columns = sMax + 1;
        this.lns = new double[rows][columns];
        this.dlns = new double[rows][columns];
        double[] roaPow = new double[rows];
        roaPow[0] = 1.0;
        for (int i = 1; i <= nMax; ++i) {
            roaPow[i] = roa * roaPow[i - 1];
        }
        for (int s = 0; s <= sMax; ++s) {
            for (int n = s; n <= nMax; ++n) {
                if ((n - s) % 2 == 0) {
                    double coef = roaPow[n] * (Double)Vns.get(new CoefficientsFactory.NSKey(n, s));
                    this.lns[n][s] = coef * Qns[n][s];
                    if (n == s) {
                        this.dlns[n][s] = 0.0;
                        continue;
                    }
                    this.dlns[n][s] = coef * Qns[n][s + 1];
                    continue;
                }
                this.lns[n][s] = 0.0;
                this.dlns[n][s] = 0.0;
            }
        }
    }

    public double getLns(int n, int s) {
        return this.lns[n][s];
    }

    public double getdLnsdGamma(int n, int s) {
        return this.dlns[n][s];
    }
}

