/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.analysis.differentiation.FieldGradient;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.polynomials.JacobiKey;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.analysis.polynomials.PolynomialsUtils;

public class JacobiPolynomials {
    private static final Map<JacobiKey, List<PolynomialFunction>> MAP = new HashMap<JacobiKey, List<PolynomialFunction>>();

    private JacobiPolynomials() {
    }

    public static double[] getValueAndDerivative(int l, int v, int w, double x) {
        return JacobiPolynomials.getValueAndDerivative(JacobiPolynomials.computePolynomial(l, v, w), x);
    }

    private static double[] getValueAndDerivative(PolynomialFunction polynomial, double x) {
        double[] coefficients = polynomial.getCoefficients();
        int degree = polynomial.degree();
        double value = coefficients[degree];
        double derivative = value * (double)degree;
        for (int j = degree - 1; j >= 1; --j) {
            double coef = coefficients[j];
            value = value * x + coef;
            derivative = derivative * x + coef * (double)j;
        }
        if (degree > 0) {
            value = value * x + coefficients[0];
        }
        return new double[]{value, derivative};
    }

    public static Gradient getValue(int l, int v, int w, Gradient gamma) {
        return (Gradient)JacobiPolynomials.computePolynomial(l, v, w).value((Derivative)gamma);
    }

    public static <T extends CalculusFieldElement<T>> FieldGradient<T> getValue(int l, int v, int w, FieldGradient<T> gamma) {
        return (FieldGradient)JacobiPolynomials.computePolynomial(l, v, w).value(gamma);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PolynomialFunction computePolynomial(int l, int v, int w) {
        PolynomialFunction polynomial;
        List<PolynomialFunction> polyList;
        Map<JacobiKey, List<PolynomialFunction>> map = MAP;
        synchronized (map) {
            JacobiKey key = new JacobiKey(v, w);
            if (!MAP.containsKey(key)) {
                MAP.put(key, new ArrayList());
            }
            polyList = MAP.get(key);
        }
        List<PolynomialFunction> list = polyList;
        synchronized (list) {
            for (int degree = polyList.size(); degree <= l; ++degree) {
                polyList.add(degree, PolynomialsUtils.createJacobiPolynomial((int)degree, (int)v, (int)w));
            }
            polynomial = polyList.get(l);
        }
        return polynomial;
    }
}

