/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.Arrays;
import org.hipparchus.fraction.BigFraction;
import org.hipparchus.util.FastMath;

public class GammaMnsFunction {
    private static double[] PRECOMPUTED_RATIOS;
    private final double[] ratios;
    private final double[] values;
    private final double opIg;
    private final int I;

    public GammaMnsFunction(int nMax, double gamma, int I) {
        int size = (nMax + 1) * (nMax + 2) * (4 * nMax + 3) / 6;
        this.values = new double[size];
        this.ratios = GammaMnsFunction.getRatios(nMax, size);
        Arrays.fill(this.values, Double.NaN);
        this.opIg = 1.0 + (double)I * gamma;
        this.I = I;
    }

    private static int index(int m, int n, int s) {
        return n * (n + 1) * (4 * n - 1) / 6 + m * (2 * n + 1) + s + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double[] getRatios(int nMax, int size) {
        Class<GammaMnsFunction> clazz = GammaMnsFunction.class;
        synchronized (GammaMnsFunction.class) {
            if (PRECOMPUTED_RATIOS == null || PRECOMPUTED_RATIOS.length < size) {
                BigFraction[] bF = new BigFraction[size];
                for (int n = 0; n <= nMax; ++n) {
                    bF[GammaMnsFunction.index((int)0, (int)n, (int)0)] = BigFraction.ONE;
                    for (int m = 1; m <= n; ++m) {
                        bF[GammaMnsFunction.index((int)m, (int)n, (int)0)] = bF[GammaMnsFunction.index(m - 1, n, 0)].multiply(n + m).divide(n - (m - 1));
                    }
                    for (int absS = 1; absS <= n; ++absS) {
                        for (int m = 0; m <= n; ++m) {
                            bF[GammaMnsFunction.index((int)m, (int)n, (int)absS)] = bF[GammaMnsFunction.index(m, n, absS - 1)].divide(n + absS).multiply(n - (absS - 1));
                            bF[GammaMnsFunction.index((int)m, (int)n, (int)(-absS))] = bF[GammaMnsFunction.index(m, n, absS)];
                        }
                    }
                }
                PRECOMPUTED_RATIOS = new double[size];
                for (int i = 0; i < bF.length; ++i) {
                    GammaMnsFunction.PRECOMPUTED_RATIOS[i] = bF[i].doubleValue();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return PRECOMPUTED_RATIOS;
        }
    }

    public double getValue(int m, int n, int s) {
        int i = GammaMnsFunction.index(m, n, s);
        if (Double.isNaN(this.values[i])) {
            this.values[i] = s <= -m ? (double)((m - s & 1) == 0 ? 1 : -1) * FastMath.scalb((double)FastMath.pow((double)this.opIg, (int)(-this.I * m)), (int)s) : (s <= m ? (double)((m - s & 1) == 0 ? 1 : -1) * FastMath.scalb((double)FastMath.pow((double)this.opIg, (int)(this.I * s)), (int)(-m)) * this.ratios[i] : FastMath.scalb((double)FastMath.pow((double)this.opIg, (int)(this.I * m)), (int)(-s)));
        }
        return this.values[i];
    }

    public double getDerivative(int m, int n, int s) {
        if (s <= -m) {
            return (double)(-m * this.I) * this.getValue(m, n, s) / this.opIg;
        }
        if (s >= m) {
            return (double)(m * this.I) * this.getValue(m, n, s) / this.opIg;
        }
        return (double)(s * this.I) * this.getValue(m, n, s) / this.opIg;
    }
}

