/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.SortedMap;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;

public class FieldLnsCoefficients<T extends CalculusFieldElement<T>> {
    private final T[][] lns;
    private final T[][] dlns;

    public FieldLnsCoefficients(int nMax, int sMax, T[][] Qns, SortedMap<CoefficientsFactory.NSKey, Double> Vns, T roa, Field<T> field) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        int rows = nMax + 1;
        int columns = sMax + 1;
        this.lns = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)rows, (int)columns);
        this.dlns = (CalculusFieldElement[][])MathArrays.buildArray(field, (int)rows, (int)columns);
        CalculusFieldElement[] roaPow = (CalculusFieldElement[])MathArrays.buildArray(field, (int)rows);
        roaPow[0] = (CalculusFieldElement)zero.newInstance(1.0);
        for (int i = 1; i <= nMax; ++i) {
            roaPow[i] = (CalculusFieldElement)roa.multiply((FieldElement)roaPow[i - 1]);
        }
        for (int s = 0; s <= sMax; ++s) {
            for (int n = s; n <= nMax; ++n) {
                if ((n - s) % 2 == 0) {
                    CalculusFieldElement coef = (CalculusFieldElement)roaPow[n].multiply(((Double)Vns.get(new CoefficientsFactory.NSKey(n, s))).doubleValue());
                    this.lns[n][s] = (CalculusFieldElement)coef.multiply(Qns[n][s]);
                    if (n == s) {
                        this.dlns[n][s] = zero;
                        continue;
                    }
                    this.dlns[n][s] = (CalculusFieldElement)coef.multiply(Qns[n][s + 1]);
                    continue;
                }
                this.lns[n][s] = zero;
                this.dlns[n][s] = zero;
            }
        }
    }

    public T getLns(int n, int s) {
        return this.lns[n][s];
    }

    public T getdLnsdGamma(int n, int s) {
        return this.dlns[n][s];
    }
}

