/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.fraction.BigFraction;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class FieldGammaMnsFunction<T extends CalculusFieldElement<T>> {
    private static double[] PRECOMPUTED_RATIOS;
    private final double[] ratios;
    private final T[] values;
    private final T opIg;
    private final int I;

    public FieldGammaMnsFunction(int nMax, T gamma, int I, Field<T> field) {
        int size = (nMax + 1) * (nMax + 2) * (4 * nMax + 3) / 6;
        this.values = (CalculusFieldElement[])MathArrays.buildArray(field, (int)size);
        this.ratios = FieldGammaMnsFunction.getRatios(nMax, size);
        Arrays.fill(this.values, ((CalculusFieldElement)field.getZero()).add(Double.NaN));
        this.opIg = (CalculusFieldElement)((CalculusFieldElement)gamma.multiply(I)).add(1.0);
        this.I = I;
    }

    private static int index(int m, int n, int s) {
        return n * (n + 1) * (4 * n - 1) / 6 + m * (2 * n + 1) + s + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double[] getRatios(int nMax, int size) {
        Class<FieldGammaMnsFunction> clazz = FieldGammaMnsFunction.class;
        synchronized (FieldGammaMnsFunction.class) {
            if (PRECOMPUTED_RATIOS == null || PRECOMPUTED_RATIOS.length < size) {
                BigFraction[] bF = new BigFraction[size];
                for (int n = 0; n <= nMax; ++n) {
                    bF[FieldGammaMnsFunction.index((int)0, (int)n, (int)0)] = BigFraction.ONE;
                    for (int m = 1; m <= n; ++m) {
                        bF[FieldGammaMnsFunction.index((int)m, (int)n, (int)0)] = bF[FieldGammaMnsFunction.index(m - 1, n, 0)].multiply(n + m).divide(n - (m - 1));
                    }
                    for (int absS = 1; absS <= n; ++absS) {
                        for (int m = 0; m <= n; ++m) {
                            bF[FieldGammaMnsFunction.index((int)m, (int)n, (int)absS)] = bF[FieldGammaMnsFunction.index(m, n, absS - 1)].divide(n + absS).multiply(n - (absS - 1));
                            bF[FieldGammaMnsFunction.index((int)m, (int)n, (int)(-absS))] = bF[FieldGammaMnsFunction.index(m, n, absS)];
                        }
                    }
                }
                PRECOMPUTED_RATIOS = new double[size];
                for (int i = 0; i < bF.length; ++i) {
                    FieldGammaMnsFunction.PRECOMPUTED_RATIOS[i] = bF[i].doubleValue();
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return PRECOMPUTED_RATIOS;
        }
    }

    public T getValue(int m, int n, int s) {
        int i = FieldGammaMnsFunction.index(m, n, s);
        if (Double.isNaN(this.values[i].getReal())) {
            this.values[i] = s <= -m ? (CalculusFieldElement)FastMath.scalb((CalculusFieldElement)FastMath.pow(this.opIg, (int)(-this.I * m)), (int)s).multiply((m - s & 1) == 0 ? 1 : -1) : (s <= m ? (CalculusFieldElement)((CalculusFieldElement)FastMath.scalb((CalculusFieldElement)FastMath.pow(this.opIg, (int)(this.I * s)), (int)(-m)).multiply(this.ratios[i])).multiply((m - s & 1) == 0 ? 1 : -1) : FastMath.scalb((CalculusFieldElement)FastMath.pow(this.opIg, (int)(this.I * m)), (int)(-s)));
        }
        return this.values[i];
    }

    public T getDerivative(int m, int n, int s) {
        if (s <= -m) {
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getValue(m, n, s).multiply(this.I)).multiply(-m)).divide(this.opIg));
        }
        if (s >= m) {
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getValue(m, n, s).multiply(this.I)).multiply(m)).divide(this.opIg));
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getValue(m, n, s).multiply(this.I)).multiply(s)).divide(this.opIg));
    }
}

