/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.NullArgumentException;

public class FieldCjSjCoefficient<T extends CalculusFieldElement<T>> {
    private final T zero;
    private int jLast;
    private final FieldComplex<T> kih;
    private final List<FieldComplex<T>> cjsj;

    public FieldCjSjCoefficient(T k, T h, Field<T> field) {
        this.zero = (CalculusFieldElement)field.getZero();
        this.kih = new FieldComplex<T>(k, h);
        this.cjsj = new ArrayList<FieldComplex<T>>();
        this.cjsj.add(new FieldComplex<CalculusFieldElement>((CalculusFieldElement)this.zero.newInstance(1.0), (CalculusFieldElement)this.zero));
        this.cjsj.add(this.kih);
        this.jLast = 1;
    }

    public T getCj(int j) {
        if (j > this.jLast) {
            this.updateCjSj(j);
        }
        return this.cjsj.get(j).getReal();
    }

    public T getSj(int j) {
        if (j > this.jLast) {
            this.updateCjSj(j);
        }
        return this.cjsj.get(j).getImaginary();
    }

    public T getDcjDk(int j) {
        return (T)(j == 0 ? this.zero : (CalculusFieldElement)this.getCj(j - 1).multiply(j));
    }

    public T getDsjDk(int j) {
        return (T)(j == 0 ? this.zero : (CalculusFieldElement)this.getSj(j - 1).multiply(j));
    }

    public T getDcjDh(int j) {
        return (T)(j == 0 ? this.zero : (CalculusFieldElement)this.getSj(j - 1).multiply(-j));
    }

    public T getDsjDh(int j) {
        return (T)(j == 0 ? this.zero : (CalculusFieldElement)this.getCj(j - 1).multiply(j));
    }

    private void updateCjSj(int j) {
        FieldComplex<T> last = this.cjsj.get(this.cjsj.size() - 1);
        for (int i = this.jLast; i < j; ++i) {
            FieldComplex<T> next = last.multiply(this.kih);
            this.cjsj.add(next);
            last = next;
        }
        this.jLast = j;
    }

    private static class FieldComplex<T extends CalculusFieldElement<T>> {
        private final T imaginary;
        private final T real;

        FieldComplex(T real, T imaginary) {
            this.real = real;
            this.imaginary = imaginary;
        }

        public T getReal() {
            return this.real;
        }

        public T getImaginary() {
            return this.imaginary;
        }

        protected FieldComplex<T> createComplex(T realPart, T imaginaryPart) {
            return new FieldComplex<T>(realPart, imaginaryPart);
        }

        public FieldComplex<T> multiply(FieldComplex<T> factor) throws NullArgumentException {
            return this.createComplex((CalculusFieldElement)((CalculusFieldElement)this.real.multiply(factor.real)).subtract((FieldElement)((CalculusFieldElement)this.imaginary.multiply(factor.imaginary))), (CalculusFieldElement)((CalculusFieldElement)this.real.multiply(factor.imaginary)).add((FieldElement)((CalculusFieldElement)this.imaginary.multiply(factor.real))));
        }
    }
}

