/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.time.AbsoluteDate;

public class AuxiliaryElements {
    private final AbsoluteDate date;
    private final Frame frame;
    private final double ecc;
    private final double n;
    private final double period;
    private final double sma;
    private final double k;
    private final double h;
    private final double q;
    private final double p;
    private final double lm;
    private final double lv;
    private final double le;
    private final int I;
    private Orbit orbit;
    private final double B;
    private final double C;
    private final Vector3D f;
    private final Vector3D g;
    private final Vector3D w;

    public AuxiliaryElements(Orbit orbit, int retrogradeFactor) {
        this.orbit = orbit;
        this.date = orbit.getDate();
        this.frame = orbit.getFrame();
        this.ecc = orbit.getE();
        this.n = orbit.getKeplerianMeanMotion();
        this.period = orbit.getKeplerianPeriod();
        this.sma = orbit.getA();
        this.k = orbit.getEquinoctialEx();
        this.h = orbit.getEquinoctialEy();
        this.q = orbit.getHx();
        this.p = orbit.getHy();
        this.lm = MathUtils.normalizeAngle((double)orbit.getLM(), (double)Math.PI);
        this.lv = MathUtils.normalizeAngle((double)orbit.getLv(), (double)Math.PI);
        this.le = MathUtils.normalizeAngle((double)orbit.getLE(), (double)Math.PI);
        this.I = retrogradeFactor;
        double k2 = this.k * this.k;
        double h2 = this.h * this.h;
        double q2 = this.q * this.q;
        double p2 = this.p * this.p;
        this.B = FastMath.sqrt((double)(1.0 - k2 - h2));
        this.C = 1.0 + q2 + p2;
        double ooC = 1.0 / this.C;
        double px2 = 2.0 * this.p;
        double qx2 = 2.0 * this.q;
        double pq2 = px2 * this.q;
        this.f = new Vector3D(ooC, new Vector3D(1.0 - p2 + q2, pq2, -px2 * (double)this.I));
        this.g = new Vector3D(ooC, new Vector3D(pq2 * (double)this.I, (1.0 + p2 - q2) * (double)this.I, qx2));
        this.w = new Vector3D(ooC, new Vector3D(px2, -qx2, (1.0 - p2 - q2) * (double)this.I));
    }

    public Orbit getOrbit() {
        return this.orbit;
    }

    public AbsoluteDate getDate() {
        return this.date;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public double getEcc() {
        return this.ecc;
    }

    public double getMeanMotion() {
        return this.n;
    }

    public double getKeplerianPeriod() {
        return this.period;
    }

    public double getSma() {
        return this.sma;
    }

    public double getK() {
        return this.k;
    }

    public double getH() {
        return this.h;
    }

    public double getQ() {
        return this.q;
    }

    public double getP() {
        return this.p;
    }

    public double getLM() {
        return this.lm;
    }

    public double getLv() {
        return this.lv;
    }

    public double getLf() {
        return this.le;
    }

    public int getRetrogradeFactor() {
        return this.I;
    }

    public double getB() {
        return this.B;
    }

    public double getC() {
        return this.C;
    }

    public Vector3D getVectorF() {
        return this.f;
    }

    public Vector3D getVectorG() {
        return this.g;
    }

    public Vector3D getVectorW() {
        return this.w;
    }

    @Deprecated
    public double getAlpha() {
        return this.f.getZ();
    }

    @Deprecated
    public double getBeta() {
        return this.g.getZ();
    }

    @Deprecated
    public double getGamma() {
        return this.w.getZ();
    }
}

