/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTJ2SquaredClosedFormContext;
import org.orekit.propagation.semianalytical.dsst.forces.FieldDSSTJ2SquaredClosedFormContext;
import org.orekit.propagation.semianalytical.dsst.forces.J2SquaredModel;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;

public class ZeisModel
implements J2SquaredModel {
    private static final int I = 1;

    @Override
    public double[] computeMeanEquinoctialSecondOrderTerms(DSSTJ2SquaredClosedFormContext context) {
        AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
        double c2z = this.computeC2Z(context);
        double s2mf = 19.0 * context.getS2() - 15.0;
        double s2pIcmo = context.getS2() + 1.0 * context.getC() - 1.0;
        double s4mts2 = 19.0 * context.getS2() * context.getS2() - 30.0 * context.getS2() + 12.0;
        double deltaA = 0.0;
        double deltaK = -c2z * auxiliaryElements.getH() * s2mf * s2pIcmo;
        double deltaH = c2z * auxiliaryElements.getK() * s2mf * s2pIcmo;
        double deltaQ = -c2z * context.getC() * auxiliaryElements.getP() * s2mf;
        double deltaP = c2z * context.getC() * auxiliaryElements.getQ() * s2mf;
        double deltaM = 0.5 * c2z * (2.0 * s2mf * s2pIcmo + 5.0 * s4mts2 * context.getEta());
        return new double[]{0.0, deltaK, deltaH, deltaQ, deltaP, deltaM};
    }

    @Override
    public <T extends CalculusFieldElement<T>> T[] computeMeanEquinoctialSecondOrderTerms(FieldDSSTJ2SquaredClosedFormContext<T> context) {
        FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
        Field field = auxiliaryElements.getDate().getField();
        T c2z = this.computeC2Z(context);
        CalculusFieldElement s2mf = (CalculusFieldElement)((CalculusFieldElement)context.getS2().multiply(19.0)).subtract(15.0);
        CalculusFieldElement s2pIcmo = (CalculusFieldElement)((CalculusFieldElement)context.getS2().add((FieldElement)((CalculusFieldElement)context.getC().multiply(1)))).subtract(1.0);
        CalculusFieldElement s4mts2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)context.getS2().multiply(context.getS2())).multiply(19.0)).subtract((FieldElement)((CalculusFieldElement)context.getS2().multiply(30.0)))).add(12.0);
        CalculusFieldElement deltaA = (CalculusFieldElement)field.getZero();
        CalculusFieldElement deltaK = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c2z.multiply(auxiliaryElements.getH())).multiply((FieldElement)s2mf)).multiply((FieldElement)s2pIcmo)).negate();
        CalculusFieldElement deltaH = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c2z.multiply(auxiliaryElements.getK())).multiply((FieldElement)s2mf)).multiply((FieldElement)s2pIcmo);
        CalculusFieldElement deltaQ = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c2z.multiply(context.getC())).multiply(auxiliaryElements.getP())).multiply((FieldElement)s2mf)).negate();
        CalculusFieldElement deltaP = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c2z.multiply(context.getC())).multiply(auxiliaryElements.getQ())).multiply((FieldElement)s2mf);
        CalculusFieldElement deltaM = (CalculusFieldElement)((CalculusFieldElement)c2z.multiply(0.5)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s2mf.multiply((FieldElement)s2pIcmo)).multiply(2.0)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)s4mts2.multiply(context.getEta())).multiply(5.0)))));
        CalculusFieldElement[] terms = (CalculusFieldElement[])MathArrays.buildArray(field, (int)6);
        terms[0] = deltaA;
        terms[1] = deltaK;
        terms[2] = deltaH;
        terms[3] = deltaQ;
        terms[4] = deltaP;
        terms[5] = deltaM;
        return terms;
    }

    public double computeC2Z(DSSTJ2SquaredClosedFormContext context) {
        AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
        return 0.75 * context.getAlpha4() * auxiliaryElements.getMeanMotion() / (context.getA4() * context.getEta());
    }

    public <T extends CalculusFieldElement<T>> T computeC2Z(FieldDSSTJ2SquaredClosedFormContext<T> context) {
        FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getMeanMotion().multiply(context.getAlpha4())).multiply(0.75)).divide((FieldElement)((CalculusFieldElement)context.getA4().multiply(context.getEta()))));
    }
}

