/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.propagation.semianalytical.dsst.forces.FieldDSSTGravityContext;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;

public class FieldDSSTZonalContext<T extends CalculusFieldElement<T>>
extends FieldDSSTGravityContext<T> {
    private final T chi3;
    private T hk;
    private T k2mh2;
    private T k2mh2o2;
    private T oon2a2;
    private T oon2a;
    private T x3on2a;
    private T xon2a2;
    private T cxo2n2a2;
    private T x2on2a2xp1;
    private T BB;

    @Deprecated
    FieldDSSTZonalContext(FieldAuxiliaryElements<T> auxiliaryElements, UnnormalizedSphericalHarmonicsProvider provider, T[] parameters) {
        this(auxiliaryElements, auxiliaryElements.getFrame(), provider, (CalculusFieldElement[])parameters);
    }

    FieldDSSTZonalContext(FieldAuxiliaryElements<T> auxiliaryElements, Frame centralBodyFrame, UnnormalizedSphericalHarmonicsProvider provider, T[] parameters) {
        super(auxiliaryElements, centralBodyFrame, provider, parameters);
        Object chi = this.getChi();
        this.chi3 = (CalculusFieldElement)chi.multiply(this.getChi2());
        this.hk = (CalculusFieldElement)auxiliaryElements.getH().multiply(auxiliaryElements.getK());
        this.k2mh2 = (CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getK().multiply(auxiliaryElements.getK())).subtract((FieldElement)((CalculusFieldElement)auxiliaryElements.getH().multiply(auxiliaryElements.getH())));
        this.k2mh2o2 = (CalculusFieldElement)this.k2mh2.divide(2.0);
        this.oon2a2 = (CalculusFieldElement)((CalculusFieldElement)this.getA().multiply(this.getMeanMotion())).reciprocal();
        this.oon2a = (CalculusFieldElement)auxiliaryElements.getSma().multiply(this.oon2a2);
        this.x3on2a = (CalculusFieldElement)this.chi3.multiply(this.oon2a);
        this.xon2a2 = (CalculusFieldElement)chi.multiply(this.oon2a2);
        this.cxo2n2a2 = (CalculusFieldElement)((CalculusFieldElement)this.xon2a2.multiply(auxiliaryElements.getC())).divide(2.0);
        this.x2on2a2xp1 = (CalculusFieldElement)((CalculusFieldElement)this.xon2a2.multiply(chi)).divide((FieldElement)((CalculusFieldElement)chi.add(1.0)));
        this.BB = (CalculusFieldElement)auxiliaryElements.getB().multiply(auxiliaryElements.getB());
    }

    @Deprecated
    public T getX() {
        return this.getChi();
    }

    @Deprecated
    public T getXX() {
        return this.getChi2();
    }

    @Deprecated
    public T getChi3() {
        return this.chi3;
    }

    @Deprecated
    public T getXXX() {
        return this.getChi3();
    }

    @Deprecated
    public T getM2aoA() {
        return (T)((CalculusFieldElement)this.getAx2oA().negate());
    }

    @Deprecated
    public T getMCo2AB() {
        return (T)((CalculusFieldElement)this.getCo2AB().negate());
    }

    public T getHK() {
        return this.hk;
    }

    public T getK2MH2() {
        return this.k2mh2;
    }

    public T getK2MH2O2() {
        return this.k2mh2o2;
    }

    public T getOON2A2() {
        return this.oon2a2;
    }

    public T getX3ON2A() {
        return this.x3on2a;
    }

    public T getXON2A2() {
        return this.xon2a2;
    }

    public T getCXO2N2A2() {
        return this.cxo2n2a2;
    }

    public T getX2ON2A2XP1() {
        return this.x2on2a2xp1;
    }

    public T getBB() {
        return this.BB;
    }
}

