/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.propagation.semianalytical.dsst.forces.FieldForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;

public class FieldDSSTThirdBodyDynamicContext<T extends CalculusFieldElement<T>>
extends FieldForceModelContext<T> {
    private T gm;
    private T R3;
    private T A;
    private T alpha;
    private T beta;
    private T gamma;
    private T BB;
    private T BBB;
    private T X;
    private T XX;
    private T XXX;
    private T m2aoA;
    private T BoA;
    private T ooAB;
    private T mCo2AB;
    private T BoABpo;
    private T muoR3;
    private T b;
    private T hXXX;
    private T kXXX;
    private T motion;

    public FieldDSSTThirdBodyDynamicContext(FieldAuxiliaryElements<T> aux, CelestialBody body, T[] parameters) {
        super(aux);
        T mu = parameters[1];
        this.A = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)mu.multiply(aux.getSma())));
        this.gm = parameters[0];
        CalculusFieldElement absA = FastMath.abs(aux.getSma());
        this.motion = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)mu.divide((FieldElement)absA))).divide((FieldElement)absA);
        FieldVector3D bodyPos = body.getPVCoordinates(aux.getDate(), aux.getFrame()).getPosition();
        this.R3 = bodyPos.getNorm();
        FieldVector3D bodyDir = bodyPos.normalize();
        this.alpha = bodyDir.dotProduct(aux.getVectorF());
        this.beta = bodyDir.dotProduct(aux.getVectorG());
        this.gamma = bodyDir.dotProduct(aux.getVectorW());
        this.BB = (CalculusFieldElement)aux.getB().multiply(aux.getB());
        this.BBB = (CalculusFieldElement)this.BB.multiply(aux.getB());
        this.b = (CalculusFieldElement)((CalculusFieldElement)aux.getB().add(1.0)).reciprocal();
        this.X = (CalculusFieldElement)aux.getB().reciprocal();
        this.XX = (CalculusFieldElement)this.X.square();
        this.XXX = (CalculusFieldElement)this.X.multiply(this.XX);
        this.m2aoA = (CalculusFieldElement)((CalculusFieldElement)aux.getSma().multiply(-2.0)).divide(this.A);
        this.BoA = (CalculusFieldElement)aux.getB().divide(this.A);
        this.ooAB = (CalculusFieldElement)((CalculusFieldElement)this.A.multiply(aux.getB())).reciprocal();
        this.mCo2AB = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aux.getC().multiply(this.ooAB)).divide(2.0)).negate();
        this.BoABpo = (CalculusFieldElement)this.BoA.divide((FieldElement)((CalculusFieldElement)aux.getB().add(1.0)));
        this.muoR3 = (CalculusFieldElement)((CalculusFieldElement)this.R3.divide(this.gm)).reciprocal();
        this.hXXX = (CalculusFieldElement)this.XXX.multiply(aux.getH());
        this.kXXX = (CalculusFieldElement)this.XXX.multiply(aux.getK());
    }

    public T getA() {
        return this.A;
    }

    public T getR3() {
        return this.R3;
    }

    public T getAlpha() {
        return this.alpha;
    }

    public T getBeta() {
        return this.beta;
    }

    public T getGamma() {
        return this.gamma;
    }

    public T getBB() {
        return this.BB;
    }

    public T getBBB() {
        return this.BBB;
    }

    public T getb() {
        return this.b;
    }

    public T getX() {
        return this.X;
    }

    public T getXX() {
        return this.XX;
    }

    public T getM2aoA() {
        return this.m2aoA;
    }

    public T getBoA() {
        return this.BoA;
    }

    public T getOoAB() {
        return this.ooAB;
    }

    public T getMCo2AB() {
        return this.mCo2AB;
    }

    public T getBoABpo() {
        return this.BoABpo;
    }

    public T getMuoR3() {
        return this.muoR3;
    }

    public T getHXXX() {
        return this.hXXX;
    }

    public T getKXXX() {
        return this.kXXX;
    }

    public T getMeanMotion() {
        return this.motion;
    }
}

