/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.Frame;
import org.orekit.propagation.semianalytical.dsst.forces.FieldDSSTGravityContext;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;

public class FieldDSSTTesseralContext<T extends CalculusFieldElement<T>>
extends FieldDSSTGravityContext<T> {
    private static final int I = 1;
    private T theta;
    private T e2;
    private T period;
    private T ratio;

    FieldDSSTTesseralContext(FieldAuxiliaryElements<T> auxiliaryElements, Frame centralBodyFrame, UnnormalizedSphericalHarmonicsProvider provider, int maxFrequencyShortPeriodics, double bodyPeriod, T[] parameters) {
        super(auxiliaryElements, centralBodyFrame, provider, parameters);
        Field<T> field = auxiliaryElements.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        T a = auxiliaryElements.getSma();
        this.period = a.getReal() < 0.0 ? (CalculusFieldElement)zero.newInstance(Double.POSITIVE_INFINITY) : (CalculusFieldElement)((CalculusFieldElement)this.getMeanMotion().reciprocal()).multiply(Math.PI * 2);
        this.e2 = (CalculusFieldElement)auxiliaryElements.getEcc().multiply(auxiliaryElements.getEcc());
        FieldStaticTransform t = this.getBodyFixedToInertialTransform();
        FieldVector3D xB = t.transformVector(FieldVector3D.getPlusI(field));
        FieldVector3D yB = t.transformVector(FieldVector3D.getPlusJ(field));
        this.theta = FastMath.atan2((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getVectorF().dotProduct(yB).negate()).add((FieldElement)((CalculusFieldElement)auxiliaryElements.getVectorG().dotProduct(xB).multiply(1)))), (CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getVectorF().dotProduct(xB).add((FieldElement)((CalculusFieldElement)auxiliaryElements.getVectorG().dotProduct(yB).multiply(1)))));
        this.ratio = (CalculusFieldElement)this.period.divide(bodyPeriod);
    }

    public T getE2() {
        return this.e2;
    }

    public T getTheta() {
        return this.theta;
    }

    @Deprecated
    public T getMoa() {
        return this.getMuoa();
    }

    public T getOrbitPeriod() {
        return this.period;
    }

    public T getRatio() {
        return this.ratio;
    }
}

