/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.propagation.semianalytical.dsst.forces.FieldForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;

public class FieldDSSTJ2SquaredClosedFormContext<T extends CalculusFieldElement<T>>
extends FieldForceModelContext<T> {
    private final double alpha4;
    private final T a4;
    private final T eta;
    private final T c;
    private final T s2;

    public FieldDSSTJ2SquaredClosedFormContext(FieldAuxiliaryElements<T> auxiliaryElements, UnnormalizedSphericalHarmonicsProvider provider) {
        super(auxiliaryElements);
        T inc = auxiliaryElements.getOrbit().getI();
        FieldSinCos scI = FastMath.sinCos(inc);
        this.c = (CalculusFieldElement)scI.cos();
        this.s2 = (CalculusFieldElement)((CalculusFieldElement)scI.sin()).multiply((FieldElement)((CalculusFieldElement)scI.sin()));
        double alpha2 = provider.getAe() * provider.getAe();
        this.alpha4 = alpha2 * alpha2;
        this.eta = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getEcc().multiply(auxiliaryElements.getEcc())).negate()).add(1.0)));
        CalculusFieldElement a2 = (CalculusFieldElement)auxiliaryElements.getSma().multiply(auxiliaryElements.getSma());
        this.a4 = (CalculusFieldElement)a2.square();
    }

    public double getAlpha4() {
        return this.alpha4;
    }

    public T getA4() {
        return this.a4;
    }

    public T getEta() {
        return this.eta;
    }

    public T getC() {
        return this.c;
    }

    public T getS2() {
        return this.s2;
    }
}

