/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.Frame;
import org.orekit.propagation.semianalytical.dsst.forces.FieldForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;

public class FieldDSSTGravityContext<T extends CalculusFieldElement<T>>
extends FieldForceModelContext<T> {
    private final T A;
    private final T chi;
    private final T chi2;
    private final T ax2oA;
    private final T ooAB;
    private final T BoA;
    private final T BoABpo;
    private final T Co2AB;
    private final T muoa;
    private final T roa;
    private final T n;
    private final T alpha;
    private final T beta;
    private final T gamma;
    private final FieldStaticTransform<T> bodyFixedToInertialTransform;

    FieldDSSTGravityContext(FieldAuxiliaryElements<T> auxiliaryElements, Frame centralBodyFixedFrame, UnnormalizedSphericalHarmonicsProvider provider, T[] parameters) {
        super(auxiliaryElements);
        T mu = parameters[0];
        T a = auxiliaryElements.getSma();
        CalculusFieldElement absA = FastMath.abs(a);
        this.n = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)mu.divide((FieldElement)absA))).divide((FieldElement)absA);
        this.A = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)mu.multiply((FieldElement)absA)));
        T B = auxiliaryElements.getB();
        this.chi = (CalculusFieldElement)auxiliaryElements.getB().reciprocal();
        this.chi2 = (CalculusFieldElement)this.chi.multiply(this.chi);
        this.ax2oA = (CalculusFieldElement)((CalculusFieldElement)a.divide(this.A)).multiply(2.0);
        this.BoA = (CalculusFieldElement)B.divide(this.A);
        this.ooAB = (CalculusFieldElement)((CalculusFieldElement)this.A.multiply(B)).reciprocal();
        this.Co2AB = (CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getC().multiply(this.ooAB)).divide(2.0);
        this.BoABpo = (CalculusFieldElement)this.BoA.divide((FieldElement)((CalculusFieldElement)B.add(1.0)));
        this.muoa = (CalculusFieldElement)mu.divide(a);
        this.roa = (CalculusFieldElement)((CalculusFieldElement)a.divide(provider.getAe())).reciprocal();
        Frame internalCentralBodyFrame = centralBodyFixedFrame == null ? auxiliaryElements.getFrame() : centralBodyFixedFrame;
        this.bodyFixedToInertialTransform = internalCentralBodyFrame.getStaticTransformTo(auxiliaryElements.getFrame(), auxiliaryElements.getDate());
        FieldVector3D<T> zB = this.bodyFixedToInertialTransform.transformVector(Vector3D.PLUS_K);
        this.alpha = FieldVector3D.dotProduct(zB, auxiliaryElements.getVectorF());
        this.beta = FieldVector3D.dotProduct(zB, auxiliaryElements.getVectorG());
        this.gamma = FieldVector3D.dotProduct(zB, auxiliaryElements.getVectorW());
    }

    public T getA() {
        return this.A;
    }

    public T getChi() {
        return this.chi;
    }

    public T getChi2() {
        return this.chi2;
    }

    public T getAx2oA() {
        return this.ax2oA;
    }

    public T getOoAB() {
        return this.ooAB;
    }

    public T getBoA() {
        return this.BoA;
    }

    public T getBoABpo() {
        return this.BoABpo;
    }

    public T getCo2AB() {
        return this.Co2AB;
    }

    public T getMuoa() {
        return this.muoa;
    }

    public T getRoa() {
        return this.roa;
    }

    public T getMeanMotion() {
        return this.n;
    }

    public T getAlpha() {
        return this.alpha;
    }

    public T getBeta() {
        return this.beta;
    }

    public T getGamma() {
        return this.gamma;
    }

    public FieldStaticTransform<T> getBodyFixedToInertialTransform() {
        return this.bodyFixedToInertialTransform;
    }
}

