/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.semianalytical.dsst.forces.FieldForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;

public class FieldAbstractGaussianContributionContext<T extends CalculusFieldElement<T>>
extends FieldForceModelContext<T> {
    protected T ton2a;
    protected T ooA;
    protected T ooAB;
    protected T co2AB;
    protected T ooBpo;
    protected T ooMu;
    private final T A;
    private final T n;
    private T mu;

    FieldAbstractGaussianContributionContext(FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
        super(auxiliaryElements);
        this.mu = parameters[parameters.length - 1];
        CalculusFieldElement absA = FastMath.abs(auxiliaryElements.getSma());
        this.n = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)this.mu.divide((FieldElement)absA))).divide((FieldElement)absA);
        this.A = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)this.mu.multiply(auxiliaryElements.getSma())));
        this.ooA = (CalculusFieldElement)this.A.reciprocal();
        this.ooAB = (CalculusFieldElement)this.ooA.divide(auxiliaryElements.getB());
        this.co2AB = (CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getC().multiply(this.ooAB)).divide(2.0);
        this.ooBpo = (CalculusFieldElement)((CalculusFieldElement)auxiliaryElements.getB().add(1.0)).reciprocal();
        this.ton2a = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.n.multiply(this.n)).multiply(auxiliaryElements.getSma())).divide(2.0)).reciprocal();
        this.ooMu = (CalculusFieldElement)this.mu.reciprocal();
    }

    public T getMu() {
        return this.mu;
    }

    public T getA() {
        return this.A;
    }

    public T getOOA() {
        return this.ooA;
    }

    public T getOOAB() {
        return this.ooAB;
    }

    public T getCo2AB() {
        return this.co2AB;
    }

    public T getOoBpo() {
        return this.ooBpo;
    }

    public T getTon2a() {
        return this.ton2a;
    }

    public T getOoMU() {
        return this.ooMu;
    }

    public T getMeanMotion() {
        return this.n;
    }
}

