/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTGravityContext;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;

public class DSSTZonalContext
extends DSSTGravityContext {
    private final double chi3;
    private double hk;
    private double k2mh2;
    private double k2mh2o2;
    private double oon2a2;
    private double oon2a;
    private double x3on2a;
    private double xon2a2;
    private double cxo2n2a2;
    private double x2on2a2xp1;
    private double BB;

    @Deprecated
    DSSTZonalContext(AuxiliaryElements auxiliaryElements, UnnormalizedSphericalHarmonicsProvider provider, double[] parameters) {
        this(auxiliaryElements, auxiliaryElements.getFrame(), provider, parameters);
    }

    DSSTZonalContext(AuxiliaryElements auxiliaryElements, Frame bodyFixedFrame, UnnormalizedSphericalHarmonicsProvider provider, double[] parameters) {
        super(auxiliaryElements, bodyFixedFrame, provider, parameters);
        double chi = this.getChi();
        this.chi3 = chi * this.getChi2();
        this.hk = auxiliaryElements.getH() * auxiliaryElements.getK();
        this.k2mh2 = auxiliaryElements.getK() * auxiliaryElements.getK() - auxiliaryElements.getH() * auxiliaryElements.getH();
        this.k2mh2o2 = this.k2mh2 / 2.0;
        this.oon2a2 = 1.0 / (this.getA() * this.getMeanMotion());
        this.oon2a = auxiliaryElements.getSma() * this.oon2a2;
        this.x3on2a = this.chi3 * this.oon2a;
        this.xon2a2 = this.getChi() * this.oon2a2;
        this.cxo2n2a2 = this.xon2a2 * auxiliaryElements.getC() / 2.0;
        this.x2on2a2xp1 = this.xon2a2 * chi / (chi + 1.0);
        this.BB = auxiliaryElements.getB() * auxiliaryElements.getB();
    }

    @Deprecated
    public double getX() {
        return this.getChi();
    }

    @Deprecated
    public double getXX() {
        return this.getChi2();
    }

    public double getChi3() {
        return this.chi3;
    }

    @Deprecated
    public double getXXX() {
        return this.getChi3();
    }

    @Deprecated
    public double getM2aoA() {
        return -this.getAx2oA();
    }

    @Deprecated
    public double getMCo2AB() {
        return -this.getCo2AB();
    }

    public double getHK() {
        return this.hk;
    }

    public double getK2MH2() {
        return this.k2mh2;
    }

    public double getK2MH2O2() {
        return this.k2mh2o2;
    }

    public double getOON2A2() {
        return this.oon2a2;
    }

    public double getX3ON2A() {
        return this.x3on2a;
    }

    public double getXON2A2() {
        return this.xon2a2;
    }

    public double getCXO2N2A2() {
        return this.cxo2n2a2;
    }

    public double getX2ON2A2XP1() {
        return this.x2on2a2xp1;
    }

    public double getBB() {
        return this.BB;
    }
}

