/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.util.FastMath;
import org.orekit.propagation.semianalytical.dsst.forces.ForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.UpperBounds;

public class DSSTThirdBodyStaticContext
extends ForceModelContext {
    private int maxAR3Pow;
    private int maxEccPow;
    private int maxFreqF;

    public DSSTThirdBodyStaticContext(AuxiliaryElements aux, double x, double r3, double[] parameters) {
        super(aux);
        int dim = 44;
        double[] fact = new double[44];
        fact[0] = 1.0;
        for (int i = 1; i < 44; ++i) {
            fact[i] = (double)i * fact[i - 1];
        }
        double aor = aux.getSma() / r3;
        double tol = aor > 0.3 || aor > 0.15 && aux.getEcc() > 0.25 ? 0.1 : 1.9E-6;
        double eo2 = FastMath.max((double)0.0025, (double)(0.5 * aux.getEcc()));
        double x2o2 = 0.5 * x * x;
        double[] eccPwr = new double[22];
        double[] chiPwr = new double[22];
        eccPwr[0] = 1.0;
        chiPwr[0] = x;
        for (int i = 1; i < 22; ++i) {
            eccPwr[i] = eccPwr[i - 1] * eo2;
            chiPwr[i] = chiPwr[i - 1] * x2o2;
        }
        double ao2rxx = aor / (2.0 * x * x);
        double xmuarn = ao2rxx * ao2rxx * parameters[0] / (x * r3);
        double term = 0.0;
        this.maxAR3Pow = 2;
        this.maxEccPow = 0;
        int n = 2;
        int m = 2;
        int nsmd2 = 0;
        do {
            if ((term = xmuarn * (fact[n + m] / (fact[nsmd2] * fact[nsmd2 + m])) * (fact[n + m + 1] / (fact[m] * fact[n + 1])) * (fact[n - m + 1] / fact[n + 1]) * eccPwr[m] * UpperBounds.getDnl(x * x, chiPwr[m], n + 2, m)) < tol) {
                if (m == 0) break;
                if (m < 2) {
                    xmuarn *= ao2rxx;
                    m = 0;
                    ++n;
                    ++nsmd2;
                    continue;
                }
                m -= 2;
                ++nsmd2;
                continue;
            }
            this.maxAR3Pow = n++;
            this.maxEccPow = FastMath.max((int)m, (int)this.maxEccPow);
            xmuarn *= ao2rxx;
            ++m;
        } while (n < 22);
        this.maxEccPow = FastMath.min((int)this.maxAR3Pow, (int)this.maxEccPow);
        this.maxFreqF = this.maxAR3Pow + 1;
    }

    public int getMaxAR3Pow() {
        return this.maxAR3Pow;
    }

    public int getMaxEccPow() {
        return this.maxEccPow;
    }

    public int getMaxFreqF() {
        return this.maxFreqF;
    }
}

