/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CelestialBody;
import org.orekit.propagation.semianalytical.dsst.forces.ForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;

public class DSSTThirdBodyDynamicContext
extends ForceModelContext {
    private double gm;
    private double R3;
    private double A;
    private double alpha;
    private double beta;
    private double gamma;
    private double BB;
    private double BBB;
    private double X;
    private double XX;
    private double XXX;
    private double m2aoA;
    private double BoA;
    private double ooAB;
    private double mCo2AB;
    private double BoABpo;
    private double muoR3;
    private double b;
    private double hXXX;
    private double kXXX;
    private double motion;

    public DSSTThirdBodyDynamicContext(AuxiliaryElements aux, CelestialBody body, double[] parameters) {
        super(aux);
        double mu = parameters[1];
        this.A = FastMath.sqrt((double)(mu * aux.getSma()));
        this.gm = parameters[0];
        double absA = FastMath.abs((double)aux.getSma());
        this.motion = FastMath.sqrt((double)(mu / absA)) / absA;
        Vector3D bodyPos = body.getPosition(aux.getDate(), aux.getFrame());
        this.R3 = bodyPos.getNorm();
        Vector3D bodyDir = (Vector3D)bodyPos.normalize();
        this.alpha = bodyDir.dotProduct((Vector)aux.getVectorF());
        this.beta = bodyDir.dotProduct((Vector)aux.getVectorG());
        this.gamma = bodyDir.dotProduct((Vector)aux.getVectorW());
        this.BB = aux.getB() * aux.getB();
        this.BBB = this.BB * aux.getB();
        this.b = 1.0 / (1.0 + aux.getB());
        this.X = 1.0 / aux.getB();
        this.XX = this.X * this.X;
        this.XXX = this.X * this.XX;
        this.m2aoA = -2.0 * aux.getSma() / this.A;
        this.BoA = aux.getB() / this.A;
        this.ooAB = 1.0 / (this.A * aux.getB());
        this.mCo2AB = -aux.getC() * this.ooAB / 2.0;
        this.BoABpo = this.BoA / (1.0 + aux.getB());
        this.muoR3 = this.gm / this.R3;
        this.hXXX = aux.getH() * this.XXX;
        this.kXXX = aux.getK() * this.XXX;
    }

    public double getA() {
        return this.A;
    }

    public double getR3() {
        return this.R3;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getBB() {
        return this.BB;
    }

    public double getBBB() {
        return this.BBB;
    }

    public double getb() {
        return this.b;
    }

    public double getX() {
        return this.X;
    }

    public double getXX() {
        return this.XX;
    }

    public double getM2aoA() {
        return this.m2aoA;
    }

    public double getBoA() {
        return this.BoA;
    }

    public double getOoAB() {
        return this.ooAB;
    }

    public double getMCo2AB() {
        return this.mCo2AB;
    }

    public double getBoABpo() {
        return this.BoABpo;
    }

    public double getMuoR3() {
        return this.muoR3;
    }

    public double getHXXX() {
        return this.hXXX;
    }

    public double getKXXX() {
        return this.kXXX;
    }

    public double getMeanMotion() {
        return this.motion;
    }
}

