/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTGravityContext;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;

public class DSSTTesseralContext
extends DSSTGravityContext {
    private static final int I = 1;
    private double theta;
    private double e2;
    private double period;
    private double ratio;

    DSSTTesseralContext(AuxiliaryElements auxiliaryElements, Frame centralBodyFrame, UnnormalizedSphericalHarmonicsProvider provider, int maxFrequencyShortPeriodics, double bodyPeriod, double[] parameters) {
        super(auxiliaryElements, centralBodyFrame, provider, parameters);
        double a = auxiliaryElements.getSma();
        this.period = a < 0.0 ? Double.POSITIVE_INFINITY : Math.PI * 2 / this.getMeanMotion();
        this.e2 = auxiliaryElements.getEcc() * auxiliaryElements.getEcc();
        StaticTransform t = this.getBodyFixedToInertialTransform();
        Vector3D xB = t.transformVector(Vector3D.PLUS_I);
        Vector3D yB = t.transformVector(Vector3D.PLUS_J);
        this.theta = FastMath.atan2((double)(-auxiliaryElements.getVectorF().dotProduct((Vector)yB) + 1.0 * auxiliaryElements.getVectorG().dotProduct((Vector)xB)), (double)(auxiliaryElements.getVectorF().dotProduct((Vector)xB) + 1.0 * auxiliaryElements.getVectorG().dotProduct((Vector)yB)));
        this.ratio = this.period / bodyPeriod;
    }

    public double getE2() {
        return this.e2;
    }

    public double getTheta() {
        return this.theta;
    }

    @Deprecated
    public double getMoa() {
        return this.getMuoa();
    }

    public double getOrbitPeriod() {
        return this.period;
    }

    public double getRatio() {
        return this.ratio;
    }
}

