/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.propagation.semianalytical.dsst.forces.ForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;

public class DSSTJ2SquaredClosedFormContext
extends ForceModelContext {
    private final double alpha4;
    private final double a4;
    private final double eta;
    private final double c;
    private final double s2;

    public DSSTJ2SquaredClosedFormContext(AuxiliaryElements auxiliaryElements, UnnormalizedSphericalHarmonicsProvider provider) {
        super(auxiliaryElements);
        double inc = auxiliaryElements.getOrbit().getI();
        SinCos scI = FastMath.sinCos((double)inc);
        this.c = scI.cos();
        this.s2 = scI.sin() * scI.sin();
        double alpha2 = provider.getAe() * provider.getAe();
        this.alpha4 = alpha2 * alpha2;
        this.eta = FastMath.sqrt((double)(1.0 - auxiliaryElements.getEcc() * auxiliaryElements.getEcc()));
        double a2 = auxiliaryElements.getSma() * auxiliaryElements.getSma();
        this.a4 = a2 * a2;
    }

    public double getAlpha4() {
        return this.alpha4;
    }

    public double getA4() {
        return this.a4;
    }

    public double getEta() {
        return this.eta;
    }

    public double getC() {
        return this.c;
    }

    public double getS2() {
        return this.s2;
    }
}

