/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTJ2SquaredClosedFormContext;
import org.orekit.propagation.semianalytical.dsst.forces.FieldDSSTJ2SquaredClosedFormContext;
import org.orekit.propagation.semianalytical.dsst.forces.FieldShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.forces.J2SquaredModel;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.utils.ParameterDriver;

public class DSSTJ2SquaredClosedForm
implements DSSTForceModel {
    private final J2SquaredModel j2SquaredModel;
    private final UnnormalizedSphericalHarmonicsProvider provider;

    public DSSTJ2SquaredClosedForm(J2SquaredModel j2SquaredModel, UnnormalizedSphericalHarmonicsProvider provider) {
        this.j2SquaredModel = j2SquaredModel;
        this.provider = provider;
    }

    @Override
    public double[] getMeanElementRate(SpacecraftState state, AuxiliaryElements auxiliaryElements, double[] parameters) {
        DSSTJ2SquaredClosedFormContext context = new DSSTJ2SquaredClosedFormContext(auxiliaryElements, this.provider);
        double[] delta = this.j2SquaredModel.computeMeanEquinoctialSecondOrderTerms(context);
        double J2 = -this.provider.onDate(state.getDate()).getUnnormalizedCnm(2, 0);
        double J2SquaredOver2 = 0.5 * J2 * J2;
        double da = 0.0;
        double dk = J2SquaredOver2 * delta[1];
        double dh = J2SquaredOver2 * delta[2];
        double dq = J2SquaredOver2 * delta[3];
        double dp = J2SquaredOver2 * delta[4];
        double dM = J2SquaredOver2 * delta[5];
        return new double[]{0.0, dk, dh, dq, dp, dM};
    }

    @Override
    public <T extends CalculusFieldElement<T>> T[] getMeanElementRate(FieldSpacecraftState<T> state, FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
        Field<T> field = state.getDate().getField();
        FieldDSSTJ2SquaredClosedFormContext<T> context = new FieldDSSTJ2SquaredClosedFormContext<T>(auxiliaryElements, this.provider);
        CalculusFieldElement[] delta = this.j2SquaredModel.computeMeanEquinoctialSecondOrderTerms(context);
        double J2 = -this.provider.onDate(state.getDate().toAbsoluteDate()).getUnnormalizedCnm(2, 0);
        double J2SquaredOver2 = 0.5 * J2 * J2;
        CalculusFieldElement da = (CalculusFieldElement)field.getZero();
        CalculusFieldElement dk = (CalculusFieldElement)delta[1].multiply(J2SquaredOver2);
        CalculusFieldElement dh = (CalculusFieldElement)delta[2].multiply(J2SquaredOver2);
        CalculusFieldElement dq = (CalculusFieldElement)delta[3].multiply(J2SquaredOver2);
        CalculusFieldElement dp = (CalculusFieldElement)delta[4].multiply(J2SquaredOver2);
        CalculusFieldElement dM = (CalculusFieldElement)delta[5].multiply(J2SquaredOver2);
        CalculusFieldElement[] elements = (CalculusFieldElement[])MathArrays.buildArray(field, (int)6);
        elements[0] = da;
        elements[1] = dk;
        elements[2] = dh;
        elements[3] = dq;
        elements[4] = dp;
        elements[5] = dM;
        return elements;
    }

    @Override
    public List<ShortPeriodTerms> initializeShortPeriodTerms(AuxiliaryElements auxiliaryElements, PropagationType type, double[] parameters) {
        return this.j2SquaredModel.initializeShortPeriodTerms(auxiliaryElements, type, parameters);
    }

    @Override
    public <T extends CalculusFieldElement<T>> List<FieldShortPeriodTerms<T>> initializeShortPeriodTerms(FieldAuxiliaryElements<T> auxiliaryElements, PropagationType type, T[] parameters) {
        return this.j2SquaredModel.initializeShortPeriodTerms(auxiliaryElements, type, (CalculusFieldElement[])parameters);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void registerAttitudeProvider(AttitudeProvider attitudeProvider) {
    }

    @Override
    public void updateShortPeriodTerms(double[] parameters, SpacecraftState ... meanStates) {
        this.j2SquaredModel.updateShortPeriodTerms(parameters, meanStates);
    }

    @Override
    public <T extends CalculusFieldElement<T>> void updateShortPeriodTerms(T[] parameters, FieldSpacecraftState<T> ... meanStates) {
        this.j2SquaredModel.updateShortPeriodTerms((CalculusFieldElement[])parameters, meanStates);
    }
}

