/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.StaticTransform;
import org.orekit.propagation.semianalytical.dsst.forces.ForceModelContext;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;

public class DSSTGravityContext
extends ForceModelContext {
    private final double A;
    private final double chi;
    private final double chi2;
    private final double ax2oA;
    private final double ooAB;
    private final double BoA;
    private final double BoABpo;
    private final double Co2AB;
    private final double muoa;
    private final double roa;
    private final double n;
    private final double alpha;
    private final double beta;
    private final double gamma;
    private final StaticTransform bodyFixedToInertialTransform;

    DSSTGravityContext(AuxiliaryElements auxiliaryElements, Frame bodyFixedFrame, UnnormalizedSphericalHarmonicsProvider provider, double[] parameters) {
        super(auxiliaryElements);
        double mu = parameters[0];
        double a = auxiliaryElements.getSma();
        double absA = FastMath.abs((double)a);
        this.n = FastMath.sqrt((double)(mu / absA)) / absA;
        this.A = FastMath.sqrt((double)(mu * absA));
        double B = auxiliaryElements.getB();
        this.chi = 1.0 / B;
        this.chi2 = this.chi * this.chi;
        this.ax2oA = 2.0 * a / this.A;
        this.BoA = B / this.A;
        this.ooAB = 1.0 / (this.A * B);
        this.Co2AB = auxiliaryElements.getC() * this.ooAB / 2.0;
        this.BoABpo = this.BoA / (1.0 + B);
        this.muoa = mu / a;
        this.roa = provider.getAe() / a;
        Frame internalBodyFixedFrame = bodyFixedFrame == null ? auxiliaryElements.getFrame() : bodyFixedFrame;
        this.bodyFixedToInertialTransform = internalBodyFixedFrame.getStaticTransformTo(auxiliaryElements.getFrame(), auxiliaryElements.getDate());
        Vector3D zB = this.bodyFixedToInertialTransform.transformVector(Vector3D.PLUS_K);
        this.alpha = Vector3D.dotProduct((Vector3D)zB, (Vector3D)auxiliaryElements.getVectorF());
        this.beta = Vector3D.dotProduct((Vector3D)zB, (Vector3D)auxiliaryElements.getVectorG());
        this.gamma = Vector3D.dotProduct((Vector3D)zB, (Vector3D)auxiliaryElements.getVectorW());
    }

    public double getA() {
        return this.A;
    }

    public double getChi() {
        return this.chi;
    }

    public double getChi2() {
        return this.chi2;
    }

    public double getAx2oA() {
        return this.ax2oA;
    }

    public double getOoAB() {
        return this.ooAB;
    }

    public double getBoA() {
        return this.BoA;
    }

    public double getBoABpo() {
        return this.BoABpo;
    }

    public double getCo2AB() {
        return this.Co2AB;
    }

    public double getMuoa() {
        return this.muoa;
    }

    public double getRoa() {
        return this.roa;
    }

    public double getMeanMotion() {
        return this.n;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getGamma() {
        return this.gamma;
    }

    public StaticTransform getBodyFixedToInertialTransform() {
        return this.bodyFixedToInertialTransform;
    }
}

