/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.EventDetectorsProvider;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.FieldShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversProvider;
import org.orekit.utils.TimeSpanMap;

public interface DSSTForceModel
extends ParameterDriversProvider,
EventDetectorsProvider {
    default public void init(SpacecraftState initialState, AbsoluteDate target) {
    }

    default public <T extends CalculusFieldElement<T>> void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
        this.init(initialState.toSpacecraftState(), target.toAbsoluteDate());
    }

    @Override
    default public Stream<EventDetector> getEventDetectors() {
        return this.getEventDetectors(this.getParametersDrivers());
    }

    @Override
    default public <T extends CalculusFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventDetectors(Field<T> field) {
        return this.getFieldEventDetectors(field, this.getParametersDrivers());
    }

    public List<ShortPeriodTerms> initializeShortPeriodTerms(AuxiliaryElements var1, PropagationType var2, double[] var3);

    public <T extends CalculusFieldElement<T>> List<FieldShortPeriodTerms<T>> initializeShortPeriodTerms(FieldAuxiliaryElements<T> var1, PropagationType var2, T[] var3);

    default public double[] extractParameters(double[] parameters, AbsoluteDate date) {
        List<ParameterDriver> allParameters = this.getParametersDrivers();
        double[] outParameters = new double[allParameters.size()];
        int index = 0;
        int paramIndex = 0;
        for (ParameterDriver driver : allParameters) {
            String driverNameforDate = driver.getNameSpan(date);
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                if (span.getData().equals(driverNameforDate)) {
                    outParameters[index++] = parameters[paramIndex];
                }
                ++paramIndex;
            }
        }
        return outParameters;
    }

    default public <T extends CalculusFieldElement<T>> T[] extractParameters(T[] parameters, FieldAbsoluteDate<T> date) {
        List<ParameterDriver> allParameters = this.getParametersDrivers();
        CalculusFieldElement[] outParameters = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)allParameters.size());
        int index = 0;
        int paramIndex = 0;
        for (ParameterDriver driver : allParameters) {
            String driverNameforDate = driver.getNameSpan(date.toAbsoluteDate());
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                if (span.getData().equals(driverNameforDate)) {
                    outParameters[index++] = parameters[paramIndex];
                }
                ++paramIndex;
            }
        }
        return outParameters;
    }

    public double[] getMeanElementRate(SpacecraftState var1, AuxiliaryElements var2, double[] var3);

    public <T extends CalculusFieldElement<T>> T[] getMeanElementRate(FieldSpacecraftState<T> var1, FieldAuxiliaryElements<T> var2, T[] var3);

    public void registerAttitudeProvider(AttitudeProvider var1);

    public void updateShortPeriodTerms(double[] var1, SpacecraftState ... var2);

    public <T extends CalculusFieldElement<T>> void updateShortPeriodTerms(T[] var1, FieldSpacecraftState<T> ... var2);
}

