/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.integration.CombinedDerivatives;
import org.orekit.propagation.semianalytical.dsst.DSSTGradientConverter;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

class DSSTStateTransitionMatrixGenerator
implements AdditionalDerivativesProvider {
    private static final int SPACE_DIMENSION = 3;
    private static final int I = 1;
    public static final int STATE_DIMENSION = 6;
    private final String stmName;
    private final List<DSSTForceModel> forceModels;
    private final AttitudeProvider attitudeProvider;
    private final Map<String, DSSTPartialsObserver> partialsObservers;
    private final PropagationType propagationType;

    DSSTStateTransitionMatrixGenerator(String stmName, List<DSSTForceModel> forceModels, AttitudeProvider attitudeProvider, PropagationType propagationType) {
        this.stmName = stmName;
        this.forceModels = forceModels;
        this.attitudeProvider = attitudeProvider;
        this.propagationType = propagationType;
        this.partialsObservers = new HashMap<String, DSSTPartialsObserver>();
    }

    void addObserver(String name, DSSTPartialsObserver observer) {
        this.partialsObservers.put(name, observer);
    }

    @Override
    public String getName() {
        return this.stmName;
    }

    @Override
    public int getDimension() {
        return 36;
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        Gradient[] parameters;
        FieldSpacecraftState<Gradient> dsState;
        DSSTGradientConverter converter = new DSSTGradientConverter(initialState, this.attitudeProvider);
        PropagationType type = this.propagationType;
        for (DSSTForceModel forceModel : this.forceModels) {
            dsState = converter.getState(forceModel);
            parameters = converter.getParametersAtStateDate(dsState, forceModel);
            FieldAuxiliaryElements<Gradient> auxiliaryElements = new FieldAuxiliaryElements<Gradient>(dsState.getOrbit(), 1);
            forceModel.initializeShortPeriodTerms(auxiliaryElements, type, (CalculusFieldElement[])parameters);
        }
        if (type == PropagationType.OSCULATING) {
            for (DSSTForceModel forceModel : this.forceModels) {
                dsState = converter.getState(forceModel);
                parameters = converter.getParametersAtStateDate(dsState, forceModel);
                forceModel.updateShortPeriodTerms((CalculusFieldElement[])parameters, new FieldSpacecraftState[]{dsState});
            }
        }
    }

    @Override
    public boolean yields(SpacecraftState state) {
        return !state.hasAdditionalState(this.getName());
    }

    SpacecraftState setInitialStateTransitionMatrix(SpacecraftState state, RealMatrix dYdY0) {
        if (dYdY0 != null && (dYdY0.getRowDimension() != 6 || dYdY0.getColumnDimension() != 6)) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH_2x2, dYdY0.getRowDimension(), dYdY0.getColumnDimension(), 6, 6);
        }
        double[] flat = new double[36];
        int k = 0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                flat[k++] = dYdY0.getEntry(i, j);
            }
        }
        return state.addAdditionalState(this.stmName, flat);
    }

    @Override
    public CombinedDerivatives combinedDerivatives(SpacecraftState state) {
        double[] p = state.getAdditionalState(this.getName());
        double[] res = new double[p.length];
        RealMatrix factor = this.computePartials(state);
        int index = 0;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                double sum = 0.0;
                for (int k = 0; k < 6; ++k) {
                    sum += factor.getEntry(i, k) * p[j + k * 6];
                }
                res[index++] = sum;
            }
        }
        return new CombinedDerivatives(res, null);
    }

    private RealMatrix computePartials(SpacecraftState state) {
        RealMatrix factor = MatrixUtils.createRealMatrix((int)6, (int)6);
        DoubleArrayDictionary meanElementsPartials = new DoubleArrayDictionary();
        DSSTGradientConverter converter = new DSSTGradientConverter(state, this.attitudeProvider);
        for (DSSTForceModel dSSTForceModel : this.forceModels) {
            FieldSpacecraftState<Gradient> dsState = converter.getState(dSSTForceModel);
            Gradient[] parameters = converter.getParametersAtStateDate(dsState, dSSTForceModel);
            FieldAuxiliaryElements<Gradient> auxiliaryElements = new FieldAuxiliaryElements<Gradient>(dsState.getOrbit(), 1);
            Gradient[] meanElementRate = (Gradient[])dSSTForceModel.getMeanElementRate(dsState, auxiliaryElements, (CalculusFieldElement[])parameters);
            double[] derivativesA = meanElementRate[0].getGradient();
            double[] derivativesEx = meanElementRate[1].getGradient();
            double[] derivativesEy = meanElementRate[2].getGradient();
            double[] derivativesHx = meanElementRate[3].getGradient();
            double[] derivativesHy = meanElementRate[4].getGradient();
            double[] derivativesL = meanElementRate[5].getGradient();
            this.addToRow(derivativesA, 0, factor);
            this.addToRow(derivativesEx, 1, factor);
            this.addToRow(derivativesEy, 2, factor);
            this.addToRow(derivativesHx, 3, factor);
            this.addToRow(derivativesHy, 4, factor);
            this.addToRow(derivativesL, 5, factor);
            int paramsIndex = converter.getFreeStateParameters();
            for (ParameterDriver driver : dSSTForceModel.getParametersDrivers()) {
                if (!driver.isSelected()) continue;
                for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                    DoubleArrayDictionary.Entry entry = meanElementsPartials.getEntry(span.getData());
                    if (entry == null) {
                        meanElementsPartials.put(span.getData(), new double[6]);
                        entry = meanElementsPartials.getEntry(span.getData());
                    }
                    entry.increment(new double[]{derivativesA[paramsIndex], derivativesEx[paramsIndex], derivativesEy[paramsIndex], derivativesHx[paramsIndex], derivativesHy[paramsIndex], derivativesL[paramsIndex]});
                    ++paramsIndex;
                }
            }
        }
        for (Map.Entry entry : this.partialsObservers.entrySet()) {
            DoubleArrayDictionary.Entry entry2 = meanElementsPartials.getEntry((String)entry.getKey());
            ((DSSTPartialsObserver)entry.getValue()).partialsComputed(state, factor, entry2 == null ? new double[6] : entry2.getValue());
        }
        return factor;
    }

    private void addToRow(double[] derivatives, int index, RealMatrix factor) {
        for (int i = 0; i < 6; ++i) {
            factor.addToEntry(index, i, derivatives[i]);
        }
    }

    public static interface DSSTPartialsObserver {
        public void partialsComputed(SpacecraftState var1, RealMatrix var2, double[] var3);
    }
}

