/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hipparchus.exception.Localizable;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.sampling.ODEStateInterpolator;
import org.hipparchus.ode.sampling.ODEStepHandler;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AbstractIntegratedPropagator;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.integration.StateMapper;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.semianalytical.dsst.DSSTHarvester;
import org.orekit.propagation.semianalytical.dsst.DSSTIntegrableJacobianColumnGenerator;
import org.orekit.propagation.semianalytical.dsst.DSSTStateTransitionMatrixGenerator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTNewtonianAttraction;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FixedNumberInterpolationGrid;
import org.orekit.propagation.semianalytical.dsst.utilities.InterpolationGrid;
import org.orekit.propagation.semianalytical.dsst.utilities.MaxGapInterpolationGrid;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.ParameterObserver;
import org.orekit.utils.TimeSpanMap;

public class DSSTPropagator
extends AbstractIntegratedPropagator {
    private static final int I = 1;
    private static final double EPSILON_DEFAULT = 1.0E-13;
    private static final int MAX_ITERATIONS_DEFAULT = 200;
    private static final int INTERPOLATION_POINTS_PER_STEP = 3;
    private boolean initialIsOsculating;
    private final transient List<DSSTForceModel> forceModels = new ArrayList<DSSTForceModel>();
    private MeanPlusShortPeriodicMapper mapper;
    private InterpolationGrid interpolationgrid;
    private DSSTHarvester harvester;

    @DefaultDataContext
    public DSSTPropagator(ODEIntegrator integrator, PropagationType propagationType) {
        this(integrator, propagationType, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()));
    }

    public DSSTPropagator(ODEIntegrator integrator, PropagationType propagationType, AttitudeProvider attitudeProvider) {
        super(integrator, propagationType);
        this.initMapper();
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngleType.MEAN);
        this.setAttitudeProvider(attitudeProvider);
        this.setInterpolationGridToFixedNumberOfPoints(3);
    }

    @DefaultDataContext
    public DSSTPropagator(ODEIntegrator integrator) {
        this(integrator, PropagationType.MEAN);
    }

    @Override
    public void setMu(double mu) {
        this.addForceModel(new DSSTNewtonianAttraction(mu));
    }

    private void superSetMu(double mu) {
        super.setMu(mu);
    }

    private boolean hasNewtonianAttraction() {
        int last = this.forceModels.size() - 1;
        return last >= 0 && this.forceModels.get(last) instanceof DSSTNewtonianAttraction;
    }

    public void setInitialState(SpacecraftState initialState) {
        this.setInitialState(initialState, PropagationType.OSCULATING);
    }

    public void setInitialState(SpacecraftState initialState, PropagationType stateType) {
        this.resetInitialState(initialState, stateType);
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        super.resetInitialState(state);
        if (!this.hasNewtonianAttraction()) {
            this.setMu(state.getMu());
        }
        super.setStartDate(state.getDate());
    }

    @Override
    public void resetInitialState(SpacecraftState state, PropagationType stateType) {
        this.resetInitialState(state);
        this.initialIsOsculating = stateType == PropagationType.OSCULATING;
    }

    public void setSelectedCoefficients(Set<String> selectedCoefficients) {
        this.mapper.setSelectedCoefficients((Set<String>)(selectedCoefficients == null ? null : new HashSet<String>(selectedCoefficients)));
    }

    public Set<String> getSelectedCoefficients() {
        Set<String> set = this.mapper.getSelectedCoefficients();
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    protected List<String> getJacobiansColumnsNames() {
        ArrayList<String> columnsNames = new ArrayList<String>();
        for (DSSTForceModel forceModel : this.getAllForceModels()) {
            for (ParameterDriver driver : forceModel.getParametersDrivers()) {
                if (!driver.isSelected() || columnsNames.contains(driver.getNamesSpanMap().getFirstSpan().getData())) continue;
                for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                    columnsNames.add(span.getData());
                }
            }
        }
        Collections.sort(columnsNames);
        return columnsNames;
    }

    @Override
    public DSSTHarvester setupMatricesComputation(String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        DSSTHarvester dsstHarvester;
        if (stmName == null) {
            throw new OrekitException((Localizable)OrekitMessages.NULL_ARGUMENT, "stmName");
        }
        this.harvester = dsstHarvester = this.createHarvester(stmName, initialStm, initialJacobianColumns);
        return this.harvester;
    }

    @Override
    protected DSSTHarvester createHarvester(String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        DSSTHarvester dsstHarvester;
        this.harvester = dsstHarvester = new DSSTHarvester(this, stmName, initialStm, initialJacobianColumns);
        return dsstHarvester;
    }

    @Override
    protected DSSTHarvester getHarvester() {
        return this.harvester;
    }

    @Override
    protected void setUpStmAndJacobianGenerators() {
        DSSTHarvester dsstHarvester = this.getHarvester();
        if (dsstHarvester != null) {
            DSSTStateTransitionMatrixGenerator stmGenerator = this.setUpStmGenerator();
            this.setUpRegularParametersJacobiansColumns(stmGenerator);
            dsstHarvester.freezeColumnsNames();
        }
    }

    private DSSTStateTransitionMatrixGenerator setUpStmGenerator() {
        DSSTHarvester dsstHarvester = this.getHarvester();
        DSSTStateTransitionMatrixGenerator stmGenerator = null;
        for (AdditionalDerivativesProvider equations : this.getAdditionalDerivativesProviders()) {
            if (!(equations instanceof DSSTStateTransitionMatrixGenerator) || !equations.getName().equals(dsstHarvester.getStmName())) continue;
            stmGenerator = (DSSTStateTransitionMatrixGenerator)equations;
            break;
        }
        if (stmGenerator == null) {
            stmGenerator = new DSSTStateTransitionMatrixGenerator(dsstHarvester.getStmName(), this.getAllForceModels(), this.getAttitudeProvider(), this.getPropagationType());
            this.addAdditionalDerivativesProvider(stmGenerator);
        }
        if (!this.getInitialIntegrationState().hasAdditionalState(dsstHarvester.getStmName())) {
            this.setInitialState(stmGenerator.setInitialStateTransitionMatrix(this.getInitialState(), dsstHarvester.getInitialStateTransitionMatrix()), this.getPropagationType());
        }
        return stmGenerator;
    }

    private void setUpRegularParametersJacobiansColumns(DSSTStateTransitionMatrixGenerator stmGenerator) {
        ParameterDriversList selected = new ParameterDriversList();
        for (DSSTForceModel forceModel : this.getAllForceModels()) {
            for (ParameterDriver driver : forceModel.getParametersDrivers()) {
                selected.add(driver);
            }
        }
        selected.filter(true);
        selected.sort();
        for (ParameterDriversList.DelegatingDriver driver : selected.getDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                DSSTIntegrableJacobianColumnGenerator generator = null;
                for (AdditionalDerivativesProvider provider : this.getAdditionalDerivativesProviders()) {
                    if (!(provider instanceof DSSTIntegrableJacobianColumnGenerator) || !provider.getName().equals(span.getData())) continue;
                    generator = (DSSTIntegrableJacobianColumnGenerator)provider;
                    break;
                }
                if (generator == null) {
                    generator = new DSSTIntegrableJacobianColumnGenerator(stmGenerator, span.getData());
                    this.addAdditionalDerivativesProvider(generator);
                }
                if (this.getInitialIntegrationState().hasAdditionalState(span.getData())) continue;
                this.setInitialState(this.getInitialState().addAdditionalState(span.getData(), this.getHarvester().getInitialJacobianColumn(span.getData())), this.getPropagationType());
            }
        }
    }

    public boolean initialIsOsculating() {
        return this.initialIsOsculating;
    }

    public void setInterpolationGridToFixedNumberOfPoints(int interpolationPoints) {
        this.interpolationgrid = new FixedNumberInterpolationGrid(interpolationPoints);
    }

    public void setInterpolationGridToMaxTimeGap(double maxGap) {
        this.interpolationgrid = new MaxGapInterpolationGrid(maxGap);
    }

    public void addForceModel(DSSTForceModel force) {
        if (force instanceof DSSTNewtonianAttraction) {
            force.getParametersDrivers().get(0).addObserver(new ParameterObserver(){

                @Override
                public void valueChanged(double previousValue, ParameterDriver driver, AbsoluteDate date) {
                    DSSTPropagator.this.superSetMu(driver.getValue());
                }

                @Override
                public void valueSpanMapChanged(TimeSpanMap<Double> previousValue, ParameterDriver driver) {
                    DSSTPropagator.this.superSetMu(driver.getValue());
                }
            });
            if (this.hasNewtonianAttraction()) {
                this.forceModels.set(this.forceModels.size() - 1, force);
            } else {
                this.forceModels.add(force);
            }
        } else if (this.hasNewtonianAttraction()) {
            this.forceModels.add(this.forceModels.size() - 1, force);
        } else {
            this.forceModels.add(force);
        }
        force.registerAttitudeProvider(this.getAttitudeProvider());
    }

    public void removeForceModels() {
        int last = this.forceModels.size() - 1;
        if (this.hasNewtonianAttraction()) {
            DSSTForceModel newton = this.forceModels.get(last);
            this.forceModels.clear();
            this.forceModels.add(newton);
        } else {
            this.forceModels.clear();
        }
    }

    public List<DSSTForceModel> getAllForceModels() {
        return Collections.unmodifiableList(this.forceModels);
    }

    @Override
    public OrbitType getOrbitType() {
        return super.getOrbitType();
    }

    @Override
    public PositionAngleType getPositionAngleType() {
        return super.getPositionAngleType();
    }

    public static SpacecraftState computeOsculatingState(SpacecraftState mean, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forces) {
        AuxiliaryElements aux = new AuxiliaryElements(mean.getOrbit(), 1);
        ArrayList<ShortPeriodTerms> shortPeriodTerms = new ArrayList<ShortPeriodTerms>();
        for (DSSTForceModel force : forces) {
            force.registerAttitudeProvider(attitudeProvider);
            shortPeriodTerms.addAll(force.initializeShortPeriodTerms(aux, PropagationType.OSCULATING, force.getParameters(mean.getDate())));
            force.updateShortPeriodTerms(force.getParametersAllValues(), mean);
        }
        EquinoctialOrbit osculatingOrbit = DSSTPropagator.computeOsculatingOrbit(mean, shortPeriodTerms);
        return new SpacecraftState(osculatingOrbit, mean.getAttitude(), mean.getMass(), mean.getAdditionalStatesValues(), mean.getAdditionalStatesDerivatives());
    }

    public static SpacecraftState computeMeanState(SpacecraftState osculating, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forceModels) {
        return DSSTPropagator.computeMeanState(osculating, attitudeProvider, forceModels, 1.0E-13, 200);
    }

    public static SpacecraftState computeMeanState(SpacecraftState osculating, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forceModels, double epsilon, int maxIterations) {
        Orbit meanOrbit = DSSTPropagator.computeMeanOrbit(osculating, attitudeProvider, forceModels, epsilon, maxIterations);
        return new SpacecraftState(meanOrbit, osculating.getAttitude(), osculating.getMass(), osculating.getAdditionalStatesValues(), osculating.getAdditionalStatesDerivatives());
    }

    public void setSatelliteRevolution(int satelliteRevolution) {
        this.mapper.setSatelliteRevolution(satelliteRevolution);
    }

    public int getSatelliteRevolution() {
        return this.mapper.getSatelliteRevolution();
    }

    public void setShortPeriodTerms(List<ShortPeriodTerms> shortPeriodTerms) {
        this.mapper.setShortPeriodTerms(shortPeriodTerms);
    }

    public List<ShortPeriodTerms> getShortPeriodTerms() {
        return this.mapper.getShortPeriodTerms();
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        super.setAttitudeProvider(attitudeProvider);
        for (DSSTForceModel force : this.forceModels) {
            force.registerAttitudeProvider(attitudeProvider);
        }
    }

    @Override
    protected void beforeIntegration(SpacecraftState initialState, AbsoluteDate tEnd) {
        PropagationType type = this.getPropagationType();
        AuxiliaryElements aux = new AuxiliaryElements(initialState.getOrbit(), 1);
        ArrayList<ShortPeriodTerms> shortPeriodTerms = new ArrayList<ShortPeriodTerms>();
        for (DSSTForceModel dSSTForceModel : this.forceModels) {
            shortPeriodTerms.addAll(dSSTForceModel.initializeShortPeriodTerms(aux, type, dSSTForceModel.getParameters(initialState.getDate())));
        }
        this.mapper.setShortPeriodTerms(shortPeriodTerms);
        if (type == PropagationType.OSCULATING) {
            ShortPeriodicsHandler spHandler = new ShortPeriodicsHandler(this.forceModels);
            for (DSSTForceModel forceModel : this.forceModels) {
                forceModel.updateShortPeriodTerms(forceModel.getParametersAllValues(), initialState);
            }
            ArrayList<ShortPeriodicsHandler> arrayList = new ArrayList<ShortPeriodicsHandler>();
            arrayList.add(spHandler);
            ODEIntegrator integrator = this.getIntegrator();
            List existing = integrator.getStepHandlers();
            arrayList.addAll(existing);
            integrator.clearStepHandlers();
            for (ODEStepHandler oDEStepHandler : arrayList) {
                integrator.addStepHandler(oDEStepHandler);
            }
        }
    }

    @Override
    protected void afterIntegration() {
        if (this.getPropagationType() == PropagationType.OSCULATING) {
            ArrayList<ODEStepHandler> preserved = new ArrayList<ODEStepHandler>();
            ODEIntegrator integrator = this.getIntegrator();
            for (ODEStepHandler sp : integrator.getStepHandlers()) {
                if (sp instanceof ShortPeriodicsHandler) continue;
                preserved.add(sp);
            }
            integrator.clearStepHandlers();
            for (ODEStepHandler sp : preserved) {
                integrator.addStepHandler(sp);
            }
        }
    }

    private static Orbit computeMeanOrbit(SpacecraftState osculating, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forceModels, double epsilon, int maxIterations) {
        EquinoctialOrbit meanOrbit = (EquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(osculating.getOrbit());
        double thresholdA = epsilon * (1.0 + FastMath.abs((double)meanOrbit.getA()));
        double thresholdE = epsilon * (1.0 + meanOrbit.getE());
        double thresholdI = epsilon * (1.0 + meanOrbit.getI());
        double thresholdL = epsilon * Math.PI;
        for (DSSTForceModel force : forceModels) {
            force.registerAttitudeProvider(attitudeProvider);
        }
        int i = 0;
        while (i++ < maxIterations) {
            SpacecraftState meanState = new SpacecraftState((Orbit)meanOrbit, osculating.getAttitude(), osculating.getMass());
            AuxiliaryElements aux = new AuxiliaryElements(meanOrbit, 1);
            ArrayList<ShortPeriodTerms> shortPeriodTerms = new ArrayList<ShortPeriodTerms>();
            for (DSSTForceModel force : forceModels) {
                shortPeriodTerms.addAll(force.initializeShortPeriodTerms(aux, PropagationType.OSCULATING, force.getParameters(meanState.getDate())));
                force.updateShortPeriodTerms(force.getParametersAllValues(), meanState);
            }
            EquinoctialOrbit rebuilt = DSSTPropagator.computeOsculatingOrbit(meanState, shortPeriodTerms);
            double deltaA = osculating.getA() - rebuilt.getA();
            double deltaEx = osculating.getEquinoctialEx() - rebuilt.getEquinoctialEx();
            double deltaEy = osculating.getEquinoctialEy() - rebuilt.getEquinoctialEy();
            double deltaHx = osculating.getHx() - rebuilt.getHx();
            double deltaHy = osculating.getHy() - rebuilt.getHy();
            double deltaLM = MathUtils.normalizeAngle((double)(osculating.getLM() - rebuilt.getLM()), (double)0.0);
            if (FastMath.abs((double)deltaA) < thresholdA && FastMath.abs((double)deltaEx) < thresholdE && FastMath.abs((double)deltaEy) < thresholdE && FastMath.abs((double)deltaHx) < thresholdI && FastMath.abs((double)deltaHy) < thresholdI && FastMath.abs((double)deltaLM) < thresholdL) {
                return meanOrbit;
            }
            meanOrbit = new EquinoctialOrbit(meanOrbit.getA() + deltaA, meanOrbit.getEquinoctialEx() + deltaEx, meanOrbit.getEquinoctialEy() + deltaEy, meanOrbit.getHx() + deltaHx, meanOrbit.getHy() + deltaHy, meanOrbit.getLM() + deltaLM, PositionAngleType.MEAN, meanOrbit.getFrame(), meanOrbit.getDate(), meanOrbit.getMu());
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_DSST_MEAN_PARAMETERS, i);
    }

    private static EquinoctialOrbit computeOsculatingOrbit(SpacecraftState meanState, List<ShortPeriodTerms> shortPeriodTerms) {
        double[] mean = new double[6];
        double[] meanDot = new double[6];
        OrbitType.EQUINOCTIAL.mapOrbitToArray(meanState.getOrbit(), PositionAngleType.MEAN, mean, meanDot);
        double[] y = (double[])mean.clone();
        for (ShortPeriodTerms spt : shortPeriodTerms) {
            double[] shortPeriodic = spt.value(meanState.getOrbit());
            for (int i = 0; i < shortPeriodic.length; ++i) {
                int n = i;
                y[n] = y[n] + shortPeriodic[i];
            }
        }
        return (EquinoctialOrbit)OrbitType.EQUINOCTIAL.mapArrayToOrbit(y, meanDot, PositionAngleType.MEAN, meanState.getDate(), meanState.getMu(), meanState.getFrame());
    }

    @Override
    protected SpacecraftState getInitialIntegrationState() {
        if (this.initialIsOsculating) {
            return DSSTPropagator.computeMeanState(this.getInitialState(), this.getAttitudeProvider(), this.forceModels);
        }
        return this.getInitialState();
    }

    @Override
    protected StateMapper createMapper(AbsoluteDate referenceDate, double mu, OrbitType ignoredOrbitType, PositionAngleType ignoredPositionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
        MeanPlusShortPeriodicMapper newMapper = new MeanPlusShortPeriodicMapper(referenceDate, mu, attitudeProvider, frame);
        if (this.mapper != null) {
            newMapper.setSatelliteRevolution(this.mapper.getSatelliteRevolution());
            newMapper.setSelectedCoefficients(this.mapper.getSelectedCoefficients());
            newMapper.setShortPeriodTerms(this.mapper.getShortPeriodTerms());
        }
        this.mapper = newMapper;
        return this.mapper;
    }

    public double[] getShortPeriodTermsValue(SpacecraftState meanState) {
        double[] sptValue = new double[6];
        for (ShortPeriodTerms spt : this.mapper.getShortPeriodTerms()) {
            double[] shortPeriodic = spt.value(meanState.getOrbit());
            for (int i = 0; i < shortPeriodic.length; ++i) {
                int n = i;
                sptValue[n] = sptValue[n] + shortPeriodic[i];
            }
        }
        return sptValue;
    }

    @Override
    protected AbstractIntegratedPropagator.MainStateEquations getMainStateEquations(ODEIntegrator integrator) {
        return new Main(integrator);
    }

    public static double[][] tolerances(double dP, Orbit orbit) {
        return NumericalPropagator.tolerances(dP, orbit, OrbitType.EQUINOCTIAL);
    }

    public static double[][] tolerances(double dP, double dV, Orbit orbit) {
        return NumericalPropagator.tolerances(dP, dV, orbit, OrbitType.EQUINOCTIAL);
    }

    private class ShortPeriodicsHandler
    implements ODEStepHandler {
        private final List<DSSTForceModel> forceModels;

        ShortPeriodicsHandler(List<DSSTForceModel> forceModels) {
            this.forceModels = forceModels;
        }

        public void handleStep(ODEStateInterpolator interpolator) {
            double[] interpolationPoints = DSSTPropagator.this.interpolationgrid.getGridPoints(interpolator.getPreviousState().getTime(), interpolator.getCurrentState().getTime());
            SpacecraftState[] meanStates = new SpacecraftState[interpolationPoints.length];
            for (int i = 0; i < interpolationPoints.length; ++i) {
                double time = interpolationPoints[i];
                ODEStateAndDerivative sd = interpolator.getInterpolatedState(time);
                meanStates[i] = DSSTPropagator.this.mapper.mapArrayToState(time, sd.getPrimaryState(), sd.getPrimaryDerivative(), PropagationType.MEAN);
            }
            for (DSSTForceModel forceModel : this.forceModels) {
                forceModel.updateShortPeriodTerms(forceModel.getParametersAllValues(), meanStates);
            }
        }
    }

    private class Main
    implements AbstractIntegratedPropagator.MainStateEquations {
        private final double[] yDot = new double[7];

        Main(ODEIntegrator integrator) {
            DSSTPropagator.this.forceModels.forEach(dsstForceModel -> dsstForceModel.getEventDetectors().forEach(eventDetector -> DSSTPropagator.this.setUpEventDetector(integrator, eventDetector)));
        }

        @Override
        public void init(SpacecraftState initialState, AbsoluteDate target) {
            DSSTPropagator.this.forceModels.forEach(fm -> fm.init(initialState, target));
        }

        @Override
        public double[] computeDerivatives(SpacecraftState state) {
            Arrays.fill(this.yDot, 0.0);
            AuxiliaryElements auxiliaryElements = new AuxiliaryElements(state.getOrbit(), 1);
            for (DSSTForceModel forceModel : DSSTPropagator.this.forceModels) {
                double[] daidt = this.elementRates(forceModel, state, auxiliaryElements, forceModel.getParameters(state.getDate()));
                for (int i = 0; i < daidt.length; ++i) {
                    int n = i;
                    this.yDot[n] = this.yDot[n] + daidt[i];
                }
            }
            return (double[])this.yDot.clone();
        }

        private double[] elementRates(DSSTForceModel forceModel, SpacecraftState state, AuxiliaryElements auxiliaryElements, double[] parameters) {
            return forceModel.getMeanElementRate(state, auxiliaryElements, parameters);
        }
    }

    private static class MeanPlusShortPeriodicMapper
    extends StateMapper {
        private Set<String> selectedCoefficients = null;
        private int satelliteRevolution = 2;
        private List<ShortPeriodTerms> shortPeriodTerms = Collections.emptyList();

        MeanPlusShortPeriodicMapper(AbsoluteDate referenceDate, double mu, AttitudeProvider attitudeProvider, Frame frame) {
            super(referenceDate, mu, OrbitType.EQUINOCTIAL, PositionAngleType.MEAN, attitudeProvider, frame);
        }

        @Override
        public SpacecraftState mapArrayToState(AbsoluteDate date, double[] y, double[] yDot, PropagationType type) {
            DoubleArrayDictionary coefficients;
            double[] elements = (double[])y.clone();
            if (type == PropagationType.MEAN) {
                coefficients = null;
            } else {
                Orbit meanOrbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(elements, yDot, PositionAngleType.MEAN, date, this.getMu(), this.getFrame());
                coefficients = this.selectedCoefficients == null ? null : new DoubleArrayDictionary();
                for (ShortPeriodTerms spt : this.shortPeriodTerms) {
                    double[] shortPeriodic = spt.value(meanOrbit);
                    for (int i = 0; i < shortPeriodic.length; ++i) {
                        int n = i;
                        elements[n] = elements[n] + shortPeriodic[i];
                    }
                    if (this.selectedCoefficients == null) continue;
                    coefficients.putAll(spt.getCoefficients(date, this.selectedCoefficients));
                }
            }
            double mass = elements[6];
            if (mass <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_POSITIVE_SPACECRAFT_MASS, mass);
            }
            Orbit orbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(elements, yDot, PositionAngleType.MEAN, date, this.getMu(), this.getFrame());
            Attitude attitude = this.getAttitudeProvider().getAttitude(orbit, date, this.getFrame());
            if (coefficients == null) {
                return new SpacecraftState(orbit, attitude, mass);
            }
            return new SpacecraftState(orbit, attitude, mass, coefficients);
        }

        @Override
        public void mapStateToArray(SpacecraftState state, double[] y, double[] yDot) {
            OrbitType.EQUINOCTIAL.mapOrbitToArray(state.getOrbit(), PositionAngleType.MEAN, y, yDot);
            y[6] = state.getMass();
        }

        public void setSatelliteRevolution(int satelliteRevolution) {
            this.satelliteRevolution = satelliteRevolution;
        }

        public int getSatelliteRevolution() {
            return this.satelliteRevolution;
        }

        public void setSelectedCoefficients(Set<String> selectedCoefficients) {
            this.selectedCoefficients = selectedCoefficients;
        }

        public Set<String> getSelectedCoefficients() {
            return this.selectedCoefficients;
        }

        public void setShortPeriodTerms(List<ShortPeriodTerms> shortPeriodTerms) {
            this.shortPeriodTerms = shortPeriodTerms;
        }

        public List<ShortPeriodTerms> getShortPeriodTerms() {
            return this.shortPeriodTerms;
        }
    }
}

