/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.AbstractMatricesHarvester;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.semianalytical.dsst.DSSTGradientConverter;
import org.orekit.propagation.semianalytical.dsst.DSSTPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.FieldShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

public class DSSTHarvester
extends AbstractMatricesHarvester {
    private static final int I = 1;
    private final DSSTPropagator propagator;
    private final double[][] shortPeriodDerivativesStm;
    private final DoubleArrayDictionary shortPeriodDerivativesJacobianColumns;
    private List<String> columnsNames;
    private final Map<DSSTForceModel, List<FieldShortPeriodTerms<Gradient>>> fieldShortPeriodTerms;

    DSSTHarvester(DSSTPropagator propagator, String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        super(stmName, initialStm, initialJacobianColumns);
        this.propagator = propagator;
        this.shortPeriodDerivativesStm = new double[6][6];
        this.shortPeriodDerivativesJacobianColumns = new DoubleArrayDictionary();
        this.fieldShortPeriodTerms = new IdentityHashMap<DSSTForceModel, List<FieldShortPeriodTerms<Gradient>>>();
    }

    @Override
    public RealMatrix getStateTransitionMatrix(SpacecraftState state) {
        RealMatrix stm = super.getStateTransitionMatrix(state);
        if (this.propagator.getPropagationType() == PropagationType.OSCULATING) {
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 6; ++j) {
                    stm.addToEntry(i, j, this.shortPeriodDerivativesStm[i][j]);
                }
            }
        }
        return stm;
    }

    @Override
    public RealMatrix getParametersJacobian(SpacecraftState state) {
        RealMatrix jacobian = super.getParametersJacobian(state);
        if (jacobian != null && this.propagator.getPropagationType() == PropagationType.OSCULATING) {
            List<String> names = this.getJacobiansColumnsNames();
            for (int j = 0; j < names.size(); ++j) {
                double[] column = this.shortPeriodDerivativesJacobianColumns.get(names.get(j));
                for (int i = 0; i < 6; ++i) {
                    jacobian.addToEntry(i, j, column[i]);
                }
            }
        }
        return jacobian;
    }

    public RealMatrix getB1() {
        RealMatrix B1 = MatrixUtils.createRealMatrix((int)6, (int)6);
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                B1.addToEntry(i, j, this.shortPeriodDerivativesStm[i][j]);
            }
        }
        return B1;
    }

    public RealMatrix getB2(SpacecraftState state) {
        return super.getStateTransitionMatrix(state);
    }

    public RealMatrix getB3(SpacecraftState state) {
        return super.getParametersJacobian(state);
    }

    public RealMatrix getB4() {
        List<String> names = this.getJacobiansColumnsNames();
        RealMatrix B4 = MatrixUtils.createRealMatrix((int)6, (int)names.size());
        for (int j = 0; j < names.size(); ++j) {
            double[] column = this.shortPeriodDerivativesJacobianColumns.get(names.get(j));
            for (int i = 0; i < 6; ++i) {
                B4.addToEntry(i, j, column[i]);
            }
        }
        return B4;
    }

    @Override
    public void freezeColumnsNames() {
        this.columnsNames = this.getJacobiansColumnsNames();
    }

    @Override
    public List<String> getJacobiansColumnsNames() {
        return this.columnsNames == null ? this.propagator.getJacobiansColumnsNames() : this.columnsNames;
    }

    public void initializeFieldShortPeriodTerms(SpacecraftState reference) {
        this.initializeFieldShortPeriodTerms(reference, this.propagator.getPropagationType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFieldShortPeriodTerms(SpacecraftState reference, PropagationType type) {
        DSSTGradientConverter converter = new DSSTGradientConverter(reference, this.propagator.getAttitudeProvider());
        this.fieldShortPeriodTerms.clear();
        for (DSSTForceModel forceModel : this.propagator.getAllForceModels()) {
            List list;
            FieldSpacecraftState<Gradient> dsState = converter.getState(forceModel);
            Gradient[] dsParameters = converter.getParametersAtStateDate(dsState, forceModel);
            FieldAuxiliaryElements<Gradient> auxiliaryElements = new FieldAuxiliaryElements<Gradient>(dsState.getOrbit(), 1);
            List terms = forceModel.initializeShortPeriodTerms(auxiliaryElements, type, (CalculusFieldElement[])dsParameters);
            Map<DSSTForceModel, List<FieldShortPeriodTerms<Gradient>>> map = this.fieldShortPeriodTerms;
            synchronized (map) {
                list = this.fieldShortPeriodTerms.computeIfAbsent(forceModel, x -> new ArrayList());
            }
            list.addAll(terms);
        }
    }

    public void updateFieldShortPeriodTerms(SpacecraftState reference) {
        DSSTGradientConverter converter = new DSSTGradientConverter(reference, this.propagator.getAttitudeProvider());
        for (DSSTForceModel forceModel : this.propagator.getAllForceModels()) {
            FieldSpacecraftState<Gradient> dsState = converter.getState(forceModel);
            Gradient[] dsParameters = converter.getParameters(dsState, forceModel);
            forceModel.updateShortPeriodTerms((CalculusFieldElement[])dsParameters, new FieldSpacecraftState[]{dsState});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReferenceState(SpacecraftState reference) {
        for (double[] row : this.shortPeriodDerivativesStm) {
            Arrays.fill(row, 0.0);
        }
        this.shortPeriodDerivativesJacobianColumns.clear();
        DSSTGradientConverter converter = new DSSTGradientConverter(reference, this.propagator.getAttitudeProvider());
        for (DSSTForceModel forceModel : this.propagator.getAllForceModels()) {
            List terms;
            FieldSpacecraftState<Gradient> dsState = converter.getState(forceModel);
            Gradient zero = (Gradient)dsState.getDate().getField().getZero();
            Object[] shortPeriod = new Gradient[6];
            Arrays.fill(shortPeriod, zero);
            Map<DSSTForceModel, List<FieldShortPeriodTerms<Gradient>>> map = this.fieldShortPeriodTerms;
            synchronized (map) {
                terms = this.fieldShortPeriodTerms.computeIfAbsent(forceModel, x -> new ArrayList(0));
            }
            for (FieldShortPeriodTerms spt : terms) {
                Gradient[] spVariation = (Gradient[])spt.value(dsState.getOrbit());
                for (int i = 0; i < spVariation.length; ++i) {
                    shortPeriod[i] = shortPeriod[i].add(spVariation[i]);
                }
            }
            double[] derivativesASP = shortPeriod[0].getGradient();
            double[] derivativesExSP = shortPeriod[1].getGradient();
            double[] derivativesEySP = shortPeriod[2].getGradient();
            double[] derivativesHxSP = shortPeriod[3].getGradient();
            double[] derivativesHySP = shortPeriod[4].getGradient();
            double[] derivativesLSP = shortPeriod[5].getGradient();
            this.addToRow(derivativesASP, 0);
            this.addToRow(derivativesExSP, 1);
            this.addToRow(derivativesEySP, 2);
            this.addToRow(derivativesHxSP, 3);
            this.addToRow(derivativesHySP, 4);
            this.addToRow(derivativesLSP, 5);
            int paramsIndex = converter.getFreeStateParameters();
            for (ParameterDriver driver : forceModel.getParametersDrivers()) {
                if (!driver.isSelected()) continue;
                TimeSpanMap<String> driverNameSpanMap = driver.getNamesSpanMap();
                for (TimeSpanMap.Span<String> span = driverNameSpanMap.getFirstSpan(); span != null; span = span.next()) {
                    DoubleArrayDictionary.Entry entry = this.shortPeriodDerivativesJacobianColumns.getEntry(span.getData());
                    if (entry == null) {
                        this.shortPeriodDerivativesJacobianColumns.put(span.getData(), new double[6]);
                        entry = this.shortPeriodDerivativesJacobianColumns.getEntry(span.getData());
                    }
                    entry.increment(new double[]{derivativesASP[paramsIndex], derivativesExSP[paramsIndex], derivativesEySP[paramsIndex], derivativesHxSP[paramsIndex], derivativesHySP[paramsIndex], derivativesLSP[paramsIndex]});
                    ++paramsIndex;
                }
            }
        }
    }

    private void addToRow(double[] derivatives, int index) {
        for (int i = 0; i < 6; ++i) {
            double[] dArray = this.shortPeriodDerivativesStm[index];
            int n = i;
            dArray[n] = dArray[n] + derivatives[i];
        }
    }

    @Override
    public OrbitType getOrbitType() {
        return this.propagator.getOrbitType();
    }

    @Override
    public PositionAngleType getPositionAngleType() {
        return this.propagator.getPositionAngleType();
    }
}

