/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.sampling;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.MultiSatFixedStepHandler;
import org.orekit.propagation.sampling.MultiSatStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public class MultisatStepNormalizer
implements MultiSatStepHandler {
    private double h;
    private MultiSatFixedStepHandler handler;
    private List<SpacecraftState> lastStates;
    private boolean forward;

    public MultisatStepNormalizer(double h, MultiSatFixedStepHandler handler) {
        this.h = FastMath.abs((double)h);
        this.handler = handler;
        this.lastStates = null;
        this.forward = true;
    }

    public double getFixedTimeStep() {
        return this.h;
    }

    public MultiSatFixedStepHandler getFixedStepHandler() {
        return this.handler;
    }

    @Override
    public void init(List<SpacecraftState> s0, AbsoluteDate t) {
        this.lastStates = new ArrayList<SpacecraftState>(s0);
        this.forward = true;
        this.handler.init(s0, t, this.h);
    }

    @Override
    public void handleStep(List<OrekitStepInterpolator> interpolators) {
        AbsoluteDate nextTime;
        if (this.lastStates == null) {
            this.lastStates = interpolators.stream().map(i -> i.getPreviousState()).collect(Collectors.toList());
        }
        double step = this.h;
        this.forward = interpolators.get(0).isForward();
        if (!this.forward) {
            step = -this.h;
        }
        boolean nextInStep = this.forward ^ (nextTime = this.lastStates.get(0).getDate().shiftedBy(step)).compareTo(interpolators.get(0).getCurrentState().getDate()) > 0;
        while (nextInStep) {
            this.handler.handleStep(this.lastStates);
            AbsoluteDate time = nextTime;
            this.lastStates = interpolators.stream().map(i -> i.getInterpolatedState(time)).collect(Collectors.toList());
            nextTime = nextTime.shiftedBy(step);
            nextInStep = this.forward ^ nextTime.compareTo(interpolators.get(0).getCurrentState().getDate()) > 0;
        }
    }

    @Override
    public void finish(List<SpacecraftState> finalStates) {
        this.handler.handleStep(this.lastStates);
        this.handler.finish(finalStates);
    }
}

