/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.sampling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.sampling.FieldOrekitFixedStepHandler;
import org.orekit.propagation.sampling.FieldOrekitStepHandler;
import org.orekit.propagation.sampling.FieldOrekitStepInterpolator;
import org.orekit.propagation.sampling.FieldOrekitStepNormalizer;
import org.orekit.time.FieldAbsoluteDate;

public class FieldStepHandlerMultiplexer<T extends CalculusFieldElement<T>>
implements FieldOrekitStepHandler<T> {
    private final List<FieldOrekitStepHandler<T>> handlers = new ArrayList<FieldOrekitStepHandler<T>>();
    private FieldAbsoluteDate<T> target;
    private FieldSpacecraftState<T> last;

    public void add(FieldOrekitStepHandler<T> handler) {
        this.handlers.add(handler);
        if (this.last != null) {
            handler.init(this.last, this.target);
        }
    }

    public void add(T h, FieldOrekitFixedStepHandler<T> handler) {
        FieldOrekitStepNormalizer<T> normalized = new FieldOrekitStepNormalizer<T>(h, handler);
        this.handlers.add(normalized);
        if (this.last != null) {
            normalized.init(this.last, this.target);
        }
    }

    public List<FieldOrekitStepHandler<T>> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public void remove(FieldOrekitStepHandler<T> handler) {
        Iterator<FieldOrekitStepHandler<T>> iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != handler) continue;
            if (this.last != null) {
                handler.finish(this.last);
            }
            iterator.remove();
            return;
        }
    }

    public void remove(FieldOrekitFixedStepHandler<T> handler) {
        Iterator<FieldOrekitStepHandler<T>> iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            FieldOrekitStepHandler<T> current = iterator.next();
            if (!(current instanceof FieldOrekitStepNormalizer) || ((FieldOrekitStepNormalizer)current).getFixedStepHandler() != handler) continue;
            if (this.last != null) {
                current.finish(this.last);
            }
            iterator.remove();
            return;
        }
    }

    public void clear() {
        if (this.last != null) {
            this.handlers.forEach(h -> h.finish(this.last));
        }
        this.handlers.clear();
    }

    @Override
    public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
        this.target = t;
        this.last = s0;
        for (FieldOrekitStepHandler<T> handler : this.handlers) {
            handler.init(s0, t);
        }
    }

    @Override
    public void handleStep(FieldOrekitStepInterpolator<T> interpolator) {
        this.last = interpolator.getCurrentState();
        for (FieldOrekitStepHandler<T> handler : this.handlers) {
            handler.handleStep(interpolator);
        }
    }

    @Override
    public void finish(FieldSpacecraftState<T> finalState) {
        this.target = null;
        this.last = null;
        for (FieldOrekitStepHandler<T> handler : this.handlers) {
            handler.finish(finalState);
        }
    }
}

