/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.sampling;

import org.hipparchus.CalculusFieldElement;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.sampling.FieldOrekitFixedStepHandler;
import org.orekit.propagation.sampling.FieldOrekitStepHandler;
import org.orekit.propagation.sampling.FieldOrekitStepInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;

public class FieldOrekitStepNormalizer<T extends CalculusFieldElement<T>>
implements FieldOrekitStepHandler<T> {
    private T h;
    private FieldOrekitFixedStepHandler<T> handler;
    private FieldSpacecraftState<T> lastState;
    private boolean forward;

    public FieldOrekitStepNormalizer(T h, FieldOrekitFixedStepHandler<T> handler) {
        this.h = (CalculusFieldElement)h.abs();
        this.handler = handler;
        this.lastState = null;
        this.forward = true;
    }

    public T getFixedTimeStep() {
        return this.h;
    }

    public FieldOrekitFixedStepHandler<T> getFixedStepHandler() {
        return this.handler;
    }

    public boolean requiresDenseOutput() {
        return true;
    }

    @Override
    public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
        this.lastState = null;
        this.forward = true;
        this.handler.init(s0, t, this.h);
    }

    @Override
    public void handleStep(FieldOrekitStepInterpolator<T> interpolator) {
        FieldTimeShiftable nextTime;
        if (this.lastState == null) {
            this.lastState = interpolator.getPreviousState();
        }
        Object step = this.h;
        this.forward = interpolator.isForward();
        if (!this.forward) {
            step = (CalculusFieldElement)this.h.multiply(-1);
        }
        boolean nextInStep = this.forward ^ ((FieldAbsoluteDate)(nextTime = this.lastState.getDate().shiftedBy((CalculusFieldElement)step))).compareTo(interpolator.getCurrentState().getDate()) > 0;
        while (nextInStep) {
            this.handler.handleStep(this.lastState);
            this.lastState = interpolator.getInterpolatedState((FieldAbsoluteDate<T>)nextTime);
            nextTime = ((FieldAbsoluteDate)nextTime).shiftedBy((CalculusFieldElement)step);
            nextInStep = this.forward ^ ((FieldAbsoluteDate)nextTime).compareTo(interpolator.getCurrentState().getDate()) > 0;
        }
    }

    @Override
    public void finish(FieldSpacecraftState<T> finalState) {
        this.handler.handleStep(this.lastState);
        this.handler.finish(finalState);
    }
}

