/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical.cr3bp;

import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.numerical.cr3bp.STMEquations;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.AbstractMultipleShooting;

public class CR3BPMultipleShooter
extends AbstractMultipleShooting {
    private static final String STM = "stmEquations";
    private final List<STMEquations> stmEquations;
    private boolean isClosedOrbit;

    public CR3BPMultipleShooter(List<SpacecraftState> initialGuessList, List<NumericalPropagator> propagatorList, List<STMEquations> stmEquations, double tolerance, int maxIter) {
        super(initialGuessList, propagatorList, tolerance, maxIter, true, STM);
        this.stmEquations = stmEquations;
    }

    @Override
    protected SpacecraftState getAugmentedInitialState(int i) {
        return this.stmEquations.get(i).setInitialPhi(this.getPatchPoint(i));
    }

    @Override
    public void setEpochFreedom(int patchIndex, boolean isFree) {
        throw new OrekitException((Localizable)OrekitMessages.FUNCTION_NOT_IMPLEMENTED, new Object[0]);
    }

    @Override
    public void setScaleLength(double scaleLength) {
        throw new OrekitException((Localizable)OrekitMessages.FUNCTION_NOT_IMPLEMENTED, new Object[0]);
    }

    @Override
    public void setScaleTime(double scaleTime) {
        throw new OrekitException((Localizable)OrekitMessages.FUNCTION_NOT_IMPLEMENTED, new Object[0]);
    }

    public void setClosedOrbitConstraint(boolean isClosed) {
        this.isClosedOrbit = isClosed;
    }

    @Override
    protected double[][] computeAdditionalJacobianMatrix(List<SpacecraftState> propagatedSP) {
        Map<Integer, Double> mapConstraints = this.getConstraintsMap();
        boolean[] freeCompsMap = this.getFreeCompsMap();
        int nRows = mapConstraints.size() + (this.isClosedOrbit ? 6 : 0);
        int nCols = this.getNumberOfFreeComponents();
        double[][] M = new double[nRows][nCols];
        int j = 0;
        if (this.isClosedOrbit) {
            int i;
            int index = 0;
            for (i = 0; i < 6; ++i) {
                if (!freeCompsMap[i]) continue;
                M[i][index] = -1.0;
                ++index;
            }
            index = nCols - 6;
            for (i = 0; i < 6; ++i) {
                if (!freeCompsMap[nCols - 6 + i]) continue;
                M[i][index] = 1.0;
                ++index;
            }
            j = 6;
        }
        for (int k : mapConstraints.keySet()) {
            M[j][k] = 1.0;
            ++j;
        }
        return M;
    }

    @Override
    protected double[] computeAdditionalConstraints(List<SpacecraftState> propagatedSP) {
        Map<Integer, Double> mapConstraints = this.getConstraintsMap();
        List<SpacecraftState> patchedSpacecraftStates = this.getPatchedSpacecraftState();
        double[] fxAdditional = new double[mapConstraints.size() + (this.isClosedOrbit ? 6 : 0)];
        int i = 0;
        if (this.isClosedOrbit) {
            AbsolutePVCoordinates apv1i = patchedSpacecraftStates.get(0).getAbsPVA();
            AbsolutePVCoordinates apvni = patchedSpacecraftStates.get(patchedSpacecraftStates.size() - 1).getAbsPVA();
            fxAdditional[0] = apvni.getPosition().getX() - apv1i.getPosition().getX();
            fxAdditional[1] = apvni.getPosition().getY() - apv1i.getPosition().getY();
            fxAdditional[2] = apvni.getPosition().getZ() - apv1i.getPosition().getZ();
            fxAdditional[3] = apvni.getVelocity().getX() - apv1i.getVelocity().getX();
            fxAdditional[4] = apvni.getVelocity().getY() - apv1i.getVelocity().getY();
            fxAdditional[5] = apvni.getVelocity().getZ() - apv1i.getVelocity().getZ();
            i = 6;
        }
        this.updateAdditionalConstraints(i, fxAdditional);
        return fxAdditional;
    }

    @Override
    protected int getNumberOfConstraints() {
        return super.getNumberOfConstraints() + (this.isClosedOrbit ? 6 : 0);
    }
}

