/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical.cr3bp;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.CR3BPSystem;
import org.orekit.forces.ForceModel;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;

public class CR3BPForceModel
implements ForceModel {
    public static final String MASS_RATIO_SUFFIX = "CR3BP System Mass Ratio";
    private static final double MU_SCALE = FastMath.scalb((double)1.0, (int)32);
    private final ParameterDriver muParameterDriver;

    public CR3BPForceModel(CR3BPSystem cr3bp) {
        this.muParameterDriver = new ParameterDriver(cr3bp.getName() + MASS_RATIO_SUFFIX, cr3bp.getMassRatio(), MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) {
        double vx = s.getPVCoordinates().getVelocity().getX();
        double vy = s.getPVCoordinates().getVelocity().getY();
        DerivativeStructure potential = this.getPotential(s);
        double[] dU = potential.getAllDerivatives();
        int idX = potential.getFactory().getCompiler().getPartialDerivativeIndex(new int[]{1, 0, 0});
        int idY = potential.getFactory().getCompiler().getPartialDerivativeIndex(new int[]{0, 1, 0});
        int idZ = potential.getFactory().getCompiler().getPartialDerivativeIndex(new int[]{0, 0, 1});
        double accx = dU[idX] + 2.0 * vy;
        double accy = dU[idY] - 2.0 * vx;
        double accz = dU[idZ];
        return new Vector3D(accx, accy, accz);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) {
        CalculusFieldElement vx = s.getPVCoordinates().getVelocity().getX();
        CalculusFieldElement vy = s.getPVCoordinates().getVelocity().getY();
        FieldDerivativeStructure<T> fieldPotential = this.getPotential(s);
        CalculusFieldElement[] dU = fieldPotential.getAllDerivatives();
        int idX = fieldPotential.getFactory().getCompiler().getPartialDerivativeIndex(new int[]{1, 0, 0});
        int idY = fieldPotential.getFactory().getCompiler().getPartialDerivativeIndex(new int[]{0, 1, 0});
        int idZ = fieldPotential.getFactory().getCompiler().getPartialDerivativeIndex(new int[]{0, 0, 1});
        CalculusFieldElement accx = (CalculusFieldElement)dU[idX].add((FieldElement)((CalculusFieldElement)vy.multiply(2.0)));
        CalculusFieldElement accy = (CalculusFieldElement)dU[idY].subtract((FieldElement)((CalculusFieldElement)vx.multiply(2.0)));
        CalculusFieldElement accz = dU[idZ];
        return new FieldVector3D(accx, accy, accz);
    }

    public DerivativeStructure getPotential(SpacecraftState s) {
        DerivativeStructure mu;
        double x = s.getPosition().getX();
        double y = s.getPosition().getY();
        double z = s.getPosition().getZ();
        DSFactory factoryP = new DSFactory(3, 2);
        DerivativeStructure fpx = factoryP.variable(0, x);
        DerivativeStructure fpy = factoryP.variable(1, y);
        DerivativeStructure fpz = factoryP.variable(2, z);
        DerivativeStructure zero = (DerivativeStructure)fpx.getField().getZero();
        DerivativeStructure d1 = mu = zero.newInstance(this.muParameterDriver.getValue(s.getDate()));
        DerivativeStructure d2 = (DerivativeStructure)mu.negate().add(1.0);
        DerivativeStructure r1 = (DerivativeStructure)FastMath.sqrt((CalculusFieldElement)fpx.add(d1).multiply(fpx.add(d1)).add(fpy.square()).add(fpz.square()));
        DerivativeStructure r2 = (DerivativeStructure)FastMath.sqrt((CalculusFieldElement)fpx.subtract(d2).multiply(fpx.subtract(d2)).add(fpy.square()).add(fpz.square()));
        return ((DerivativeStructure)mu.negate().add(1.0)).divide(r1).add(mu.divide(r2)).add(fpx.square().add(fpy.square()).multiply(0.5)).add(d1.multiply(d2).multiply(0.5));
    }

    public <T extends CalculusFieldElement<T>> FieldDerivativeStructure<T> getPotential(FieldSpacecraftState<T> s) {
        FieldDerivativeStructure mu;
        CalculusFieldElement x = s.getPosition().getX();
        CalculusFieldElement y = s.getPosition().getY();
        CalculusFieldElement z = s.getPosition().getZ();
        FDSFactory factoryP = new FDSFactory(s.getDate().getField(), 3, 2);
        FieldDerivativeStructure fpx = factoryP.variable(0, x);
        FieldDerivativeStructure fpy = factoryP.variable(1, y);
        FieldDerivativeStructure fpz = factoryP.variable(2, z);
        FieldDerivativeStructure zero = (FieldDerivativeStructure)fpx.getField().getZero();
        FieldDerivativeStructure d1 = mu = zero.newInstance(this.muParameterDriver.getValue(s.getDate().toAbsoluteDate()));
        FieldDerivativeStructure d2 = mu.negate().add(1.0);
        FieldDerivativeStructure r1 = (FieldDerivativeStructure)FastMath.sqrt((CalculusFieldElement)fpx.add(d1).multiply(fpx.add(d1)).add(fpy.square()).add(fpz.square()));
        FieldDerivativeStructure r2 = (FieldDerivativeStructure)FastMath.sqrt((CalculusFieldElement)fpx.subtract(d2).multiply(fpx.subtract(d2)).add(fpy.square()).add(fpz.square()));
        return mu.negate().add(1.0).divide(r1).add(mu.divide(r2)).add(fpx.square().add(fpy.square()).multiply(0.5)).add(d1.multiply(d2).multiply(0.5));
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.muParameterDriver);
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return true;
    }
}

