/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical.cr3bp;

import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeScale;

public class CR3BPConstants {
    private CR3BPConstants() {
    }

    public static double getMoonSemiMajorAxis() {
        return 3.844E8;
    }

    public static double getEarthMoonBarycenterSemiMajorAxis(AbsoluteDate date, TimeScale timeScale) {
        double century = CR3BPConstants.getCentury(date, timeScale);
        return (1.00000261 + 5.62E-6 * century) * 1.495978707E11;
    }

    public static double getJupiterSemiMajorAxis(AbsoluteDate date, TimeScale timeScale) {
        double century = CR3BPConstants.getCentury(date, timeScale);
        return (5.202887 - 1.1607E-4 * century) * 1.495978707E11;
    }

    private static double getCentury(AbsoluteDate date, TimeScale timeScale) {
        DateComponents dc = date.getComponents(timeScale).getDate();
        return 0.01 * ((double)dc.getYear() - 2000.0);
    }
}

