/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.AttitudeProviderModifier;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.NewtonianAttraction;
import org.orekit.forces.inertia.InertialForces;
import org.orekit.forces.maneuvers.Maneuver;
import org.orekit.forces.maneuvers.jacobians.Duration;
import org.orekit.forces.maneuvers.jacobians.MedianDate;
import org.orekit.forces.maneuvers.jacobians.TriggerDate;
import org.orekit.forces.maneuvers.trigger.ManeuverTriggers;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.AbstractMatricesHarvester;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.ParameterDrivenDateIntervalDetector;
import org.orekit.propagation.integration.AbstractIntegratedPropagator;
import org.orekit.propagation.integration.AdditionalDerivativesProvider;
import org.orekit.propagation.integration.StateMapper;
import org.orekit.propagation.numerical.IntegrableJacobianColumnGenerator;
import org.orekit.propagation.numerical.NumericalPropagationHarvester;
import org.orekit.propagation.numerical.StateTransitionMatrixGenerator;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.DoubleArrayDictionary;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.ParameterObserver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedPVCoordinates;

public class NumericalPropagator
extends AbstractIntegratedPropagator {
    private static final int SPACE_DIMENSION = 3;
    private static final int STATE_DIMENSION = 6;
    private static final double THRESHOLD = Precision.SAFE_MIN;
    private final List<ForceModel> forceModels = new ArrayList<ForceModel>();
    private boolean ignoreCentralAttraction = false;
    private boolean needFullAttitudeForDerivatives = true;

    @DefaultDataContext
    public NumericalPropagator(ODEIntegrator integrator) {
        this(integrator, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()));
    }

    public NumericalPropagator(ODEIntegrator integrator, AttitudeProvider attitudeProvider) {
        super(integrator, PropagationType.OSCULATING);
        this.initMapper();
        this.setAttitudeProvider(attitudeProvider);
        this.clearStepHandlers();
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngleType.TRUE);
    }

    public void setIgnoreCentralAttraction(boolean ignoreCentralAttraction) {
        this.ignoreCentralAttraction = ignoreCentralAttraction;
    }

    @Override
    public void setMu(double mu) {
        if (this.ignoreCentralAttraction) {
            this.superSetMu(mu);
        } else {
            this.addForceModel(new NewtonianAttraction(mu));
            this.superSetMu(mu);
        }
    }

    private void superSetMu(double mu) {
        super.setMu(mu);
    }

    private boolean hasNewtonianAttraction() {
        int last = this.forceModels.size() - 1;
        return last >= 0 && this.forceModels.get(last) instanceof NewtonianAttraction;
    }

    public void addForceModel(ForceModel model) {
        if (model instanceof NewtonianAttraction) {
            try {
                model.getParametersDrivers().get(0).addObserver(new ParameterObserver(){

                    @Override
                    public void valueSpanMapChanged(TimeSpanMap<Double> previousValue, ParameterDriver driver) {
                        NumericalPropagator.this.superSetMu(driver.getValue());
                    }

                    @Override
                    public void valueChanged(double previousValue, ParameterDriver driver, AbsoluteDate date) {
                        NumericalPropagator.this.superSetMu(driver.getValue());
                    }
                });
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
            if (this.hasNewtonianAttraction()) {
                this.forceModels.set(this.forceModels.size() - 1, model);
            } else {
                this.forceModels.add(model);
            }
        } else if (this.hasNewtonianAttraction()) {
            this.forceModels.add(this.forceModels.size() - 1, model);
        } else {
            this.forceModels.add(model);
        }
    }

    public void removeForceModels() {
        int last = this.forceModels.size() - 1;
        if (this.hasNewtonianAttraction()) {
            ForceModel newton = this.forceModels.get(last);
            this.forceModels.clear();
            this.forceModels.add(newton);
        } else {
            this.forceModels.clear();
        }
    }

    public List<ForceModel> getAllForceModels() {
        return Collections.unmodifiableList(this.forceModels);
    }

    @Override
    public void setOrbitType(OrbitType orbitType) {
        super.setOrbitType(orbitType);
    }

    @Override
    public OrbitType getOrbitType() {
        return super.getOrbitType();
    }

    @Override
    public void setPositionAngleType(PositionAngleType positionAngleType) {
        super.setPositionAngleType(positionAngleType);
    }

    @Override
    public PositionAngleType getPositionAngleType() {
        return super.getPositionAngleType();
    }

    public void setInitialState(SpacecraftState initialState) {
        this.resetInitialState(initialState);
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        super.resetInitialState(state);
        if (!this.hasNewtonianAttraction()) {
            this.setMu(state.getMu());
        }
        this.setStartDate(state.getDate());
    }

    List<String> getJacobiansColumnsNames() {
        ArrayList<String> columnsNames = new ArrayList<String>();
        for (ForceModel forceModel : this.getAllForceModels()) {
            for (ParameterDriver driver : forceModel.getParametersDrivers()) {
                if (!driver.isSelected() || columnsNames.contains(driver.getNamesSpanMap().getFirstSpan().getData())) continue;
                for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                    columnsNames.add(span.getData());
                }
            }
        }
        Collections.sort(columnsNames);
        return columnsNames;
    }

    @Override
    protected AbstractMatricesHarvester createHarvester(String stmName, RealMatrix initialStm, DoubleArrayDictionary initialJacobianColumns) {
        return new NumericalPropagationHarvester(this, stmName, initialStm, initialJacobianColumns);
    }

    @Override
    protected void setUpStmAndJacobianGenerators() {
        AbstractMatricesHarvester harvester = this.getHarvester();
        if (harvester != null) {
            StateTransitionMatrixGenerator stmGenerator = this.setUpStmGenerator();
            List<String> triggersDates = this.setUpTriggerDatesJacobiansColumns(stmGenerator.getName());
            this.setUpRegularParametersJacobiansColumns(stmGenerator, triggersDates);
            harvester.freezeColumnsNames();
        }
    }

    private StateTransitionMatrixGenerator setUpStmGenerator() {
        AbstractMatricesHarvester harvester = this.getHarvester();
        StateTransitionMatrixGenerator stmGenerator = null;
        for (AdditionalDerivativesProvider equations : this.getAdditionalDerivativesProviders()) {
            if (!(equations instanceof StateTransitionMatrixGenerator) || !equations.getName().equals(harvester.getStmName())) continue;
            stmGenerator = (StateTransitionMatrixGenerator)equations;
            break;
        }
        if (stmGenerator == null) {
            stmGenerator = new StateTransitionMatrixGenerator(harvester.getStmName(), this.getAllForceModels(), this.getAttitudeProvider());
            this.addAdditionalDerivativesProvider(stmGenerator);
        }
        if (!this.getInitialIntegrationState().hasAdditionalState(harvester.getStmName())) {
            this.setInitialState(stmGenerator.setInitialStateTransitionMatrix(this.getInitialState(), harvester.getInitialStateTransitionMatrix(), this.getOrbitType(), this.getPositionAngleType()));
        }
        return stmGenerator;
    }

    private List<String> setUpTriggerDatesJacobiansColumns(String stmName) {
        ArrayList<String> names = new ArrayList<String>();
        for (ForceModel forceModel : this.getAllForceModels()) {
            if (!(forceModel instanceof Maneuver)) continue;
            Maneuver maneuver = (Maneuver)forceModel;
            ManeuverTriggers maneuverTriggers = maneuver.getManeuverTriggers();
            maneuverTriggers.getEventDetectors().filter(d -> d instanceof ParameterDrivenDateIntervalDetector).map(d -> (ParameterDrivenDateIntervalDetector)d).forEach(d -> {
                int spanNumber;
                TimeSpanMap.Span<String> span;
                if (d.getStartDriver().isSelected() || d.getMedianDriver().isSelected() || d.getDurationDriver().isSelected()) {
                    for (span = d.getStartDriver().getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                        TriggerDate start = this.manageTriggerDate(stmName, maneuver, maneuverTriggers, span.getData(), true, d.getThreshold());
                        names.add(start.getName());
                        start = null;
                    }
                }
                if (d.getStopDriver().isSelected() || d.getMedianDriver().isSelected() || d.getDurationDriver().isSelected()) {
                    for (span = d.getStopDriver().getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                        TriggerDate stop = this.manageTriggerDate(stmName, maneuver, maneuverTriggers, span.getData(), false, d.getThreshold());
                        names.add(stop.getName());
                        stop = null;
                    }
                }
                if (d.getMedianDriver().isSelected()) {
                    TimeSpanMap.Span<String> currentMedianNameSpan = d.getMedianDriver().getNamesSpanMap().getFirstSpan();
                    MedianDate median = this.manageMedianDate(d.getStartDriver().getNamesSpanMap().getFirstSpan().getData(), d.getStopDriver().getNamesSpanMap().getFirstSpan().getData(), currentMedianNameSpan.getData());
                    names.add(median.getName());
                    for (spanNumber = 1; spanNumber < d.getMedianDriver().getNamesSpanMap().getSpansNumber(); ++spanNumber) {
                        currentMedianNameSpan = d.getMedianDriver().getNamesSpanMap().getSpan(currentMedianNameSpan.getEnd());
                        median = this.manageMedianDate(d.getStartDriver().getNamesSpanMap().getSpan(currentMedianNameSpan.getStart()).getData(), d.getStopDriver().getNamesSpanMap().getSpan(currentMedianNameSpan.getStart()).getData(), currentMedianNameSpan.getData());
                        names.add(median.getName());
                    }
                }
                if (d.getDurationDriver().isSelected()) {
                    TimeSpanMap.Span<String> currentDurationNameSpan = d.getDurationDriver().getNamesSpanMap().getFirstSpan();
                    Duration duration = this.manageManeuverDuration(d.getStartDriver().getNamesSpanMap().getFirstSpan().getData(), d.getStopDriver().getNamesSpanMap().getFirstSpan().getData(), currentDurationNameSpan.getData());
                    names.add(duration.getName());
                    for (spanNumber = 1; spanNumber < d.getDurationDriver().getNamesSpanMap().getSpansNumber(); ++spanNumber) {
                        currentDurationNameSpan = d.getDurationDriver().getNamesSpanMap().getSpan(currentDurationNameSpan.getEnd());
                        duration = this.manageManeuverDuration(d.getStartDriver().getNamesSpanMap().getSpan(currentDurationNameSpan.getStart()).getData(), d.getStopDriver().getNamesSpanMap().getSpan(currentDurationNameSpan.getStart()).getData(), currentDurationNameSpan.getData());
                        names.add(duration.getName());
                    }
                }
            });
        }
        return names;
    }

    private TriggerDate manageTriggerDate(String stmName, Maneuver maneuver, ManeuverTriggers mt, String driverName, boolean start, double threshold) {
        TriggerDate triggerGenerator = null;
        for (AdditionalStateProvider provider : this.getAdditionalStateProviders()) {
            if (!(provider instanceof TriggerDate) || !provider.getName().equals(driverName)) continue;
            triggerGenerator = (TriggerDate)provider;
            break;
        }
        if (triggerGenerator == null) {
            triggerGenerator = new TriggerDate(stmName, driverName, start, maneuver, threshold);
            mt.addResetter(triggerGenerator);
            this.addAdditionalDerivativesProvider(triggerGenerator.getMassDepletionDelay());
            this.addAdditionalStateProvider(triggerGenerator);
        }
        if (!this.getInitialIntegrationState().hasAdditionalState(driverName)) {
            this.setInitialColumn(triggerGenerator.getMassDepletionDelay().getName(), new double[6]);
            this.setInitialColumn(driverName, this.getHarvester().getInitialJacobianColumn(driverName));
        }
        return triggerGenerator;
    }

    private MedianDate manageMedianDate(String startName, String stopName, String medianName) {
        MedianDate medianGenerator = null;
        for (AdditionalStateProvider provider : this.getAdditionalStateProviders()) {
            if (!(provider instanceof MedianDate) || !provider.getName().equals(medianName)) continue;
            medianGenerator = (MedianDate)provider;
            break;
        }
        if (medianGenerator == null) {
            medianGenerator = new MedianDate(startName, stopName, medianName);
            this.addAdditionalStateProvider(medianGenerator);
        }
        if (!this.getInitialIntegrationState().hasAdditionalState(medianName)) {
            this.setInitialColumn(medianName, this.getHarvester().getInitialJacobianColumn(medianName));
        }
        return medianGenerator;
    }

    private Duration manageManeuverDuration(String startName, String stopName, String durationName) {
        Duration durationGenerator = null;
        for (AdditionalStateProvider provider : this.getAdditionalStateProviders()) {
            if (!(provider instanceof Duration) || !provider.getName().equals(durationName)) continue;
            durationGenerator = (Duration)provider;
            break;
        }
        if (durationGenerator == null) {
            durationGenerator = new Duration(startName, stopName, durationName);
            this.addAdditionalStateProvider(durationGenerator);
        }
        if (!this.getInitialIntegrationState().hasAdditionalState(durationName)) {
            this.setInitialColumn(durationName, this.getHarvester().getInitialJacobianColumn(durationName));
        }
        return durationGenerator;
    }

    private void setUpRegularParametersJacobiansColumns(StateTransitionMatrixGenerator stmGenerator, List<String> triggerDates) {
        ParameterDriversList selected = new ParameterDriversList();
        for (ForceModel forceModel : this.getAllForceModels()) {
            for (ParameterDriver driver : forceModel.getParametersDrivers()) {
                if (triggerDates.contains(driver.getNamesSpanMap().getFirstSpan().getData())) continue;
                selected.add(driver);
            }
        }
        selected.filter(true);
        selected.sort();
        for (ParameterDriversList.DelegatingDriver driver : selected.getDrivers()) {
            for (TimeSpanMap.Span<String> currentNameSpan = driver.getNamesSpanMap().getFirstSpan(); currentNameSpan != null; currentNameSpan = currentNameSpan.next()) {
                IntegrableJacobianColumnGenerator generator = null;
                for (AdditionalDerivativesProvider provider : this.getAdditionalDerivativesProviders()) {
                    if (!(provider instanceof IntegrableJacobianColumnGenerator) || !provider.getName().equals(currentNameSpan.getData())) continue;
                    generator = (IntegrableJacobianColumnGenerator)provider;
                    break;
                }
                if (generator == null) {
                    generator = new IntegrableJacobianColumnGenerator(stmGenerator, currentNameSpan.getData());
                    this.addAdditionalDerivativesProvider(generator);
                }
                if (this.getInitialIntegrationState().hasAdditionalState(currentNameSpan.getData())) continue;
                this.setInitialColumn(currentNameSpan.getData(), this.getHarvester().getInitialJacobianColumn(currentNameSpan.getData()));
            }
        }
    }

    private void setInitialColumn(String columnName, double[] dYdQ) {
        SpacecraftState state = this.getInitialState();
        if (dYdQ.length != 6) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, dYdQ.length, 6);
        }
        double[][] dYdC = new double[6][6];
        this.getOrbitType().convertType(state.getOrbit()).getJacobianWrtCartesian(this.getPositionAngleType(), dYdC);
        double[] column = new QRDecomposition(MatrixUtils.createRealMatrix((double[][])dYdC), THRESHOLD).getSolver().solve(MatrixUtils.createRealVector((double[])dYdQ)).toArray();
        this.setInitialState(state.addAdditionalState(columnName, column));
    }

    @Override
    protected AttitudeProvider initializeAttitudeProviderForDerivatives() {
        AttitudeProvider attitudeProvider = this.getAttitudeProvider();
        return this.needFullAttitudeForDerivatives ? attitudeProvider : AttitudeProviderModifier.getFrozenAttitudeProvider(attitudeProvider);
    }

    @Override
    protected StateMapper createMapper(AbsoluteDate referenceDate, double mu, OrbitType orbitType, PositionAngleType positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
        return new OsculatingMapper(referenceDate, mu, orbitType, positionAngleType, attitudeProvider, frame);
    }

    @Override
    protected AbstractIntegratedPropagator.MainStateEquations getMainStateEquations(ODEIntegrator integrator) {
        return new Main(integrator);
    }

    public static double[][] tolerances(double dP, AbsolutePVCoordinates absPva) {
        double relative = dP / absPva.getPosition().getNorm();
        double dV = relative * absPva.getVelocity().getNorm();
        double[] absTol = new double[7];
        double[] relTol = new double[7];
        absTol[0] = dP;
        absTol[1] = dP;
        absTol[2] = dP;
        absTol[3] = dV;
        absTol[4] = dV;
        absTol[5] = dV;
        absTol[6] = 1.0E-6;
        Arrays.fill(relTol, relative);
        return new double[][]{absTol, relTol};
    }

    public static double[][] tolerances(double dP, Orbit orbit, OrbitType type) {
        TimeStampedPVCoordinates pv = orbit.getPVCoordinates();
        double r2 = pv.getPosition().getNormSq();
        double v = pv.getVelocity().getNorm();
        double dV = orbit.getMu() * dP / (v * r2);
        return NumericalPropagator.tolerances(dP, dV, orbit, type);
    }

    public static double[][] tolerances(double dP, double dV, Orbit orbit, OrbitType type) {
        double[] absTol = new double[7];
        double[] relTol = new double[7];
        absTol[6] = 1.0E-6;
        if (type == OrbitType.CARTESIAN) {
            absTol[0] = dP;
            absTol[1] = dP;
            absTol[2] = dP;
            absTol[3] = dV;
            absTol[4] = dV;
            absTol[5] = dV;
        } else {
            double[][] jacobian = new double[6][6];
            Orbit converted = type.convertType(orbit);
            converted.getJacobianWrtCartesian(PositionAngleType.TRUE, jacobian);
            for (int i = 0; i < 6; ++i) {
                double[] row = jacobian[i];
                absTol[i] = FastMath.abs((double)row[0]) * dP + FastMath.abs((double)row[1]) * dP + FastMath.abs((double)row[2]) * dP + FastMath.abs((double)row[3]) * dV + FastMath.abs((double)row[4]) * dV + FastMath.abs((double)row[5]) * dV;
                if (!Double.isNaN(absTol[i])) continue;
                throw new OrekitException((Localizable)OrekitMessages.SINGULAR_JACOBIAN_FOR_ORBIT_TYPE, new Object[]{type});
            }
        }
        Arrays.fill(relTol, dP / FastMath.sqrt((double)orbit.getPosition().getNormSq()));
        return new double[][]{absTol, relTol};
    }

    @Override
    protected void beforeIntegration(SpacecraftState initialState, AbsoluteDate tEnd) {
        if (!this.getFrame().isPseudoInertial()) {
            for (ForceModel force : this.forceModels) {
                if (!(force instanceof InertialForces)) continue;
                return;
            }
            throw new OrekitException((Localizable)OrekitMessages.INERTIAL_FORCE_MODEL_MISSING, this.getFrame().getName());
        }
    }

    private class Main
    implements AbstractIntegratedPropagator.MainStateEquations,
    TimeDerivativesEquations {
        private final double[] yDot = new double[7];
        private SpacecraftState currentState;
        private double[][] jacobian = new double[6][6];
        private boolean recomputingJacobian = true;

        Main(ODEIntegrator integrator) {
            for (ForceModel forceModel : NumericalPropagator.this.forceModels) {
                forceModel.getEventDetectors().forEach(detector -> NumericalPropagator.this.setUpEventDetector(integrator, detector));
            }
            for (int i = 0; i < this.jacobian.length; ++i) {
                Arrays.fill(this.jacobian[i], 0.0);
                this.jacobian[i][i] = 1.0;
            }
        }

        @Override
        public void init(SpacecraftState initialState, AbsoluteDate target) {
            NumericalPropagator.this.needFullAttitudeForDerivatives = NumericalPropagator.this.forceModels.stream().anyMatch(ForceModel::dependsOnAttitudeRate);
            NumericalPropagator.this.forceModels.forEach(fm -> fm.init(initialState, target));
            int numberOfForces = NumericalPropagator.this.forceModels.size();
            OrbitType orbitType = NumericalPropagator.this.getOrbitType();
            this.recomputingJacobian = orbitType != null && orbitType != OrbitType.CARTESIAN && numberOfForces > 0 ? (numberOfForces > 1 ? true : !(NumericalPropagator.this.forceModels.get(0) instanceof NewtonianAttraction)) : false;
        }

        @Override
        public double[] computeDerivatives(SpacecraftState state) {
            this.currentState = state;
            Arrays.fill(this.yDot, 0.0);
            if (this.recomputingJacobian) {
                this.currentState.getOrbit().getJacobianWrtCartesian(NumericalPropagator.this.getPositionAngleType(), this.jacobian);
            }
            for (ForceModel forceModel : NumericalPropagator.this.forceModels) {
                forceModel.addContribution(state, this);
            }
            if (NumericalPropagator.this.getOrbitType() == null) {
                Vector3D velocity = this.currentState.getPVCoordinates().getVelocity();
                this.yDot[0] = this.yDot[0] + velocity.getX();
                this.yDot[1] = this.yDot[1] + velocity.getY();
                this.yDot[2] = this.yDot[2] + velocity.getZ();
            }
            return (double[])this.yDot.clone();
        }

        @Override
        public void addKeplerContribution(double mu) {
            if (NumericalPropagator.this.getOrbitType() == null) {
                if (mu > 0.0) {
                    Vector3D position = this.currentState.getPosition();
                    double r2 = position.getNormSq();
                    double coeff = -mu / (r2 * FastMath.sqrt((double)r2));
                    this.yDot[3] = this.yDot[3] + coeff * position.getX();
                    this.yDot[4] = this.yDot[4] + coeff * position.getY();
                    this.yDot[5] = this.yDot[5] + coeff * position.getZ();
                }
            } else {
                this.currentState.getOrbit().addKeplerContribution(NumericalPropagator.this.getPositionAngleType(), mu, this.yDot);
            }
        }

        @Override
        public void addNonKeplerianAcceleration(Vector3D gamma) {
            int i = 0;
            while (i < 6) {
                double[] jRow = this.jacobian[i];
                int n = i++;
                this.yDot[n] = this.yDot[n] + (jRow[3] * gamma.getX() + jRow[4] * gamma.getY() + jRow[5] * gamma.getZ());
            }
        }

        @Override
        public void addMassDerivative(double q) {
            if (q > 0.0) {
                throw new OrekitIllegalArgumentException(OrekitMessages.POSITIVE_FLOW_RATE, q);
            }
            this.yDot[6] = this.yDot[6] + q;
        }
    }

    private static class OsculatingMapper
    extends StateMapper {
        OsculatingMapper(AbsoluteDate referenceDate, double mu, OrbitType orbitType, PositionAngleType positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
            super(referenceDate, mu, orbitType, positionAngleType, attitudeProvider, frame);
        }

        @Override
        public SpacecraftState mapArrayToState(AbsoluteDate date, double[] y, double[] yDot, PropagationType type) {
            double mass = y[6];
            if (mass <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_POSITIVE_SPACECRAFT_MASS, mass);
            }
            if (this.getOrbitType() == null) {
                AbsolutePVCoordinates absPva;
                Vector3D p = new Vector3D(y[0], y[1], y[2]);
                Vector3D v = new Vector3D(y[3], y[4], y[5]);
                if (yDot == null) {
                    absPva = new AbsolutePVCoordinates(this.getFrame(), new TimeStampedPVCoordinates(date, p, v));
                } else {
                    Vector3D a = new Vector3D(yDot[3], yDot[4], yDot[5]);
                    absPva = new AbsolutePVCoordinates(this.getFrame(), new TimeStampedPVCoordinates(date, p, v, a));
                }
                Attitude attitude = this.getAttitudeProvider().getAttitude(absPva, date, this.getFrame());
                return new SpacecraftState(absPva, attitude, mass);
            }
            Orbit orbit = this.getOrbitType().mapArrayToOrbit(y, yDot, this.getPositionAngleType(), date, this.getMu(), this.getFrame());
            Attitude attitude = this.getAttitudeProvider().getAttitude(orbit, date, this.getFrame());
            return new SpacecraftState(orbit, attitude, mass);
        }

        @Override
        public void mapStateToArray(SpacecraftState state, double[] y, double[] yDot) {
            if (this.getOrbitType() == null) {
                Vector3D p = state.getAbsPVA().getPosition();
                Vector3D v = state.getAbsPVA().getVelocity();
                y[0] = p.getX();
                y[1] = p.getY();
                y[2] = p.getZ();
                y[3] = v.getX();
                y[4] = v.getY();
                y[5] = v.getZ();
                y[6] = state.getMass();
            } else {
                this.getOrbitType().mapOrbitToArray(state.getOrbit(), this.getPositionAngleType(), y, yDot);
                y[6] = state.getMass();
            }
        }
    }
}

