/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.ode.FieldODEIntegrator;
import org.hipparchus.util.MathArrays;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.AttitudeProviderModifier;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.NewtonianAttraction;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.integration.FieldAbstractIntegratedPropagator;
import org.orekit.propagation.integration.FieldStateMapper;
import org.orekit.propagation.numerical.FieldTimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldAbsolutePVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldNumericalPropagator<T extends CalculusFieldElement<T>>
extends FieldAbstractIntegratedPropagator<T> {
    private final List<ForceModel> forceModels;
    private final Field<T> field;
    private boolean ignoreCentralAttraction = false;
    private boolean needFullAttitudeForDerivatives = true;

    @DefaultDataContext
    public FieldNumericalPropagator(Field<T> field, FieldODEIntegrator<T> integrator) {
        this(field, integrator, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()));
    }

    public FieldNumericalPropagator(Field<T> field, FieldODEIntegrator<T> integrator, AttitudeProvider attitudeProvider) {
        super(field, integrator, PropagationType.OSCULATING);
        this.field = field;
        this.forceModels = new ArrayList<ForceModel>();
        this.initMapper(field);
        this.setAttitudeProvider(attitudeProvider);
        this.setMu((CalculusFieldElement)((CalculusFieldElement)field.getZero()).add(Double.NaN));
        this.clearStepHandlers();
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngleType.TRUE);
    }

    public void setIgnoreCentralAttraction(boolean ignoreCentralAttraction) {
        this.ignoreCentralAttraction = ignoreCentralAttraction;
    }

    @Override
    public void setMu(T mu) {
        if (this.ignoreCentralAttraction) {
            this.superSetMu(mu);
        } else {
            this.addForceModel(new NewtonianAttraction(mu.getReal()));
        }
    }

    private void superSetMu(T mu) {
        super.setMu(mu);
    }

    private boolean hasNewtonianAttraction() {
        int last = this.forceModels.size() - 1;
        return last >= 0 && this.forceModels.get(last) instanceof NewtonianAttraction;
    }

    public void addForceModel(ForceModel model) {
        if (model instanceof NewtonianAttraction) {
            try {
                model.getParametersDrivers().get(0).addObserver(new ParameterObserver(){

                    @Override
                    public void valueChanged(double previousValue, ParameterDriver driver, AbsoluteDate date) {
                        FieldNumericalPropagator.this.superSetMu((CalculusFieldElement)((CalculusFieldElement)FieldNumericalPropagator.this.field.getZero()).newInstance(driver.getValue(date)));
                    }

                    @Override
                    public void valueSpanMapChanged(TimeSpanMap<Double> previousValue, ParameterDriver driver) {
                        FieldNumericalPropagator.this.superSetMu((CalculusFieldElement)((CalculusFieldElement)FieldNumericalPropagator.this.field.getZero()).newInstance(driver.getValue()));
                    }
                });
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
            if (this.hasNewtonianAttraction()) {
                this.forceModels.set(this.forceModels.size() - 1, model);
            } else {
                this.forceModels.add(model);
            }
        } else if (this.hasNewtonianAttraction()) {
            this.forceModels.add(this.forceModels.size() - 1, model);
        } else {
            this.forceModels.add(model);
        }
    }

    public void removeForceModels() {
        this.forceModels.clear();
    }

    public List<ForceModel> getAllForceModels() {
        return Collections.unmodifiableList(this.forceModels);
    }

    @Override
    public void setOrbitType(OrbitType orbitType) {
        super.setOrbitType(orbitType);
    }

    @Override
    public OrbitType getOrbitType() {
        return this.superGetOrbitType();
    }

    private OrbitType superGetOrbitType() {
        return super.getOrbitType();
    }

    @Override
    public void setPositionAngleType(PositionAngleType positionAngleType) {
        super.setPositionAngleType(positionAngleType);
    }

    @Override
    public PositionAngleType getPositionAngleType() {
        return super.getPositionAngleType();
    }

    public void setInitialState(FieldSpacecraftState<T> initialState) {
        this.resetInitialState(initialState);
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        super.resetInitialState(state);
        if (!this.hasNewtonianAttraction()) {
            this.setMu(state.getMu());
        }
        this.setStartDate(state.getDate());
    }

    @Override
    protected AttitudeProvider initializeAttitudeProviderForDerivatives() {
        AttitudeProvider attitudeProvider = this.getAttitudeProvider();
        return this.needFullAttitudeForDerivatives ? attitudeProvider : AttitudeProviderModifier.getFrozenAttitudeProvider(attitudeProvider);
    }

    @Override
    protected FieldStateMapper<T> createMapper(FieldAbsoluteDate<T> referenceDate, T mu, OrbitType orbitType, PositionAngleType positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
        return new FieldOsculatingMapper(this, referenceDate, mu, orbitType, positionAngleType, attitudeProvider, frame);
    }

    @Override
    protected FieldAbstractIntegratedPropagator.MainStateEquations<T> getMainStateEquations(FieldODEIntegrator<T> integrator) {
        return new Main(integrator);
    }

    public static <T extends CalculusFieldElement<T>> double[][] tolerances(T dP, FieldOrbit<T> orbit, OrbitType type) {
        TimeStampedFieldPVCoordinates<T> pv = orbit.getPVCoordinates();
        CalculusFieldElement r2 = pv.getPosition().getNormSq();
        CalculusFieldElement v = pv.getVelocity().getNorm();
        CalculusFieldElement dV = (CalculusFieldElement)((CalculusFieldElement)dP.multiply(orbit.getMu())).divide((FieldElement)((CalculusFieldElement)v.multiply((FieldElement)r2)));
        return FieldNumericalPropagator.tolerances(dP, dV, orbit, type);
    }

    public static <T extends CalculusFieldElement<T>> double[][] tolerances(T dP, T dV, FieldOrbit<T> orbit, OrbitType type) {
        double[] absTol = new double[7];
        double[] relTol = new double[7];
        absTol[6] = 1.0E-6;
        if (type == OrbitType.CARTESIAN) {
            absTol[0] = dP.getReal();
            absTol[1] = dP.getReal();
            absTol[2] = dP.getReal();
            absTol[3] = dV.getReal();
            absTol[4] = dV.getReal();
            absTol[5] = dV.getReal();
        } else {
            CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)dP.getField(), (int)6, (int)6);
            FieldOrbit<T> converted = type.convertType(orbit);
            converted.getJacobianWrtCartesian(PositionAngleType.TRUE, jacobian);
            for (int i = 0; i < 6; ++i) {
                CalculusFieldElement[] row = jacobian[i];
                absTol[i] = ((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)row[0].abs()).multiply(dP)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)row[1].abs()).multiply(dP)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)row[2].abs()).multiply(dP)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)row[3].abs()).multiply(dV)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)row[4].abs()).multiply(dV)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)row[5].abs()).multiply(dV)))).getReal();
                if (!Double.isNaN(absTol[i])) continue;
                throw new OrekitException((Localizable)OrekitMessages.SINGULAR_JACOBIAN_FOR_ORBIT_TYPE, new Object[]{type});
            }
        }
        Arrays.fill(relTol, ((CalculusFieldElement)dP.divide((FieldElement)((CalculusFieldElement)orbit.getPosition().getNormSq().sqrt()))).getReal());
        return new double[][]{absTol, relTol};
    }

    private class Main
    implements FieldAbstractIntegratedPropagator.MainStateEquations<T>,
    FieldTimeDerivativesEquations<T> {
        private final T[] yDot;
        private FieldSpacecraftState<T> currentState;
        private T[][] jacobian;
        private boolean recomputingJacobian;

        Main(FieldODEIntegrator<T> integrator) {
            this.yDot = (CalculusFieldElement[])MathArrays.buildArray(FieldNumericalPropagator.this.getField(), (int)7);
            this.jacobian = (CalculusFieldElement[][])MathArrays.buildArray(FieldNumericalPropagator.this.getField(), (int)6, (int)6);
            this.recomputingJacobian = true;
            for (ForceModel forceModel : FieldNumericalPropagator.this.forceModels) {
                forceModel.getFieldEventDetectors(FieldNumericalPropagator.this.getField()).forEach(detector -> FieldNumericalPropagator.this.setUpEventDetector(integrator, detector));
            }
            for (int i = 0; i < this.jacobian.length; ++i) {
                Arrays.fill(this.jacobian[i], FieldNumericalPropagator.this.getField().getZero());
                this.jacobian[i][i] = (CalculusFieldElement)FieldNumericalPropagator.this.getField().getOne();
            }
        }

        @Override
        public void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
            FieldNumericalPropagator.this.needFullAttitudeForDerivatives = FieldNumericalPropagator.this.forceModels.stream().anyMatch(ForceModel::dependsOnAttitudeRate);
            FieldNumericalPropagator.this.forceModels.forEach(fm -> fm.init(initialState, target));
            int numberOfForces = FieldNumericalPropagator.this.forceModels.size();
            OrbitType orbitType = FieldNumericalPropagator.this.superGetOrbitType();
            this.recomputingJacobian = orbitType != null && orbitType != OrbitType.CARTESIAN && numberOfForces > 0 ? (numberOfForces > 1 ? true : !(FieldNumericalPropagator.this.forceModels.get(0) instanceof NewtonianAttraction)) : false;
        }

        @Override
        public T[] computeDerivatives(FieldSpacecraftState<T> state) {
            CalculusFieldElement zero = (CalculusFieldElement)state.getA().getField().getZero();
            this.currentState = state;
            Arrays.fill(this.yDot, zero);
            if (this.recomputingJacobian) {
                this.currentState.getOrbit().getJacobianWrtCartesian(FieldNumericalPropagator.this.getPositionAngleType(), (CalculusFieldElement[][])this.jacobian);
            }
            for (ForceModel forceModel : FieldNumericalPropagator.this.forceModels) {
                forceModel.addContribution(state, this);
            }
            if (FieldNumericalPropagator.this.superGetOrbitType() == null) {
                FieldVector3D velocity = this.currentState.getPVCoordinates().getVelocity();
                this.yDot[0] = (CalculusFieldElement)this.yDot[0].add((FieldElement)velocity.getX());
                this.yDot[1] = (CalculusFieldElement)this.yDot[1].add((FieldElement)velocity.getY());
                this.yDot[2] = (CalculusFieldElement)this.yDot[2].add((FieldElement)velocity.getZ());
            }
            return (CalculusFieldElement[])this.yDot.clone();
        }

        @Override
        public void addKeplerContribution(T mu) {
            if (FieldNumericalPropagator.this.superGetOrbitType() == null) {
                if (mu.getReal() > 0.0) {
                    FieldVector3D position = this.currentState.getPosition();
                    CalculusFieldElement r2 = position.getNormSq();
                    CalculusFieldElement coeff = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.multiply((FieldElement)((CalculusFieldElement)r2.sqrt()))).reciprocal()).negate()).multiply(mu);
                    this.yDot[3] = (CalculusFieldElement)this.yDot[3].add((FieldElement)((CalculusFieldElement)coeff.multiply((FieldElement)position.getX())));
                    this.yDot[4] = (CalculusFieldElement)this.yDot[4].add((FieldElement)((CalculusFieldElement)coeff.multiply((FieldElement)position.getY())));
                    this.yDot[5] = (CalculusFieldElement)this.yDot[5].add((FieldElement)((CalculusFieldElement)coeff.multiply((FieldElement)position.getZ())));
                }
            } else {
                this.currentState.getOrbit().addKeplerContribution(FieldNumericalPropagator.this.getPositionAngleType(), (CalculusFieldElement)mu, (CalculusFieldElement[])this.yDot);
            }
        }

        @Override
        public void addNonKeplerianAcceleration(FieldVector3D<T> gamma) {
            for (int i = 0; i < 6; ++i) {
                T[] jRow = this.jacobian[i];
                this.yDot[i] = (CalculusFieldElement)this.yDot[i].add((FieldElement)((CalculusFieldElement)jRow[3].linearCombination(jRow[3], (FieldElement)gamma.getX(), jRow[4], (FieldElement)gamma.getY(), jRow[5], (FieldElement)gamma.getZ())));
            }
        }

        @Override
        public void addMassDerivative(T q) {
            if (q.getReal() > 0.0) {
                throw new OrekitIllegalArgumentException(OrekitMessages.POSITIVE_FLOW_RATE, q);
            }
            this.yDot[6] = (CalculusFieldElement)this.yDot[6].add(q);
        }
    }

    private static class FieldOsculatingMapper
    extends FieldStateMapper<T> {
        final /* synthetic */ FieldNumericalPropagator this$0;

        FieldOsculatingMapper(FieldAbsoluteDate<T> referenceDate, T mu, OrbitType orbitType, PositionAngleType positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
            this.this$0 = var1_1;
            super(referenceDate, mu, orbitType, positionAngleType, attitudeProvider, frame);
        }

        @Override
        public FieldSpacecraftState<T> mapArrayToState(FieldAbsoluteDate<T> date, T[] y, T[] yDot, PropagationType type) {
            Object mass = y[6];
            if (mass.getReal() <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_POSITIVE_SPACECRAFT_MASS, mass);
            }
            if (this.this$0.superGetOrbitType() == null) {
                FieldAbsolutePVCoordinates absPva;
                FieldVector3D p = new FieldVector3D(y[0], y[1], y[2]);
                FieldVector3D v = new FieldVector3D(y[3], y[4], y[5]);
                if (yDot == null) {
                    absPva = new FieldAbsolutePVCoordinates(this.getFrame(), new TimeStampedFieldPVCoordinates(date, p, v, FieldVector3D.getZero(date.getField())));
                } else {
                    FieldVector3D a = new FieldVector3D(yDot[3], yDot[4], yDot[5]);
                    absPva = new FieldAbsolutePVCoordinates(this.getFrame(), new TimeStampedFieldPVCoordinates(date, p, v, a));
                }
                FieldAttitude attitude = this.getAttitudeProvider().getAttitude(absPva, date, this.getFrame());
                return new FieldSpacecraftState(absPva, attitude, mass);
            }
            FieldOrbit orbit = this.this$0.superGetOrbitType().mapArrayToOrbit((CalculusFieldElement[])y, (CalculusFieldElement[])yDot, super.getPositionAngleType(), date, (CalculusFieldElement)this.getMu(), this.getFrame());
            FieldAttitude attitude = this.getAttitudeProvider().getAttitude(orbit, date, this.getFrame());
            return new FieldSpacecraftState(orbit, attitude, mass);
        }

        @Override
        public void mapStateToArray(FieldSpacecraftState<T> state, T[] y, T[] yDot) {
            if (this.this$0.superGetOrbitType() == null) {
                FieldVector3D p = state.getAbsPVA().getPosition();
                FieldVector3D v = state.getAbsPVA().getVelocity();
                y[0] = p.getX();
                y[1] = p.getY();
                y[2] = p.getZ();
                y[3] = v.getX();
                y[4] = v.getY();
                y[5] = v.getZ();
                y[6] = state.getMass();
            } else {
                this.this$0.superGetOrbitType().mapOrbitToArray(state.getOrbit(), super.getPositionAngleType(), (CalculusFieldElement[])y, (CalculusFieldElement[])yDot);
                y[6] = state.getMass();
            }
        }
    }
}

