/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.util.Arrays;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.ode.DenseOutputModel;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.integration.StateMapper;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.DoubleArrayDictionary;

public class IntegratedEphemeris
extends AbstractAnalyticalPropagator
implements BoundedPropagator {
    private static final double EXTRAPOLATION_TOLERANCE = 1.0;
    private final StateMapper mapper;
    private PropagationType type;
    private final AbsoluteDate startDate;
    private final AbsoluteDate minDate;
    private final AbsoluteDate maxDate;
    private DenseOutputModel model;
    private final DoubleArrayDictionary unmanaged;
    private final String[] equations;
    private final int[] dimensions;

    public IntegratedEphemeris(AbsoluteDate startDate, AbsoluteDate minDate, AbsoluteDate maxDate, StateMapper mapper, PropagationType type, DenseOutputModel model, DoubleArrayDictionary unmanaged, List<AdditionalStateProvider> providers, String[] equations, int[] dimensions) {
        super(mapper.getAttitudeProvider());
        this.startDate = startDate;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.mapper = mapper;
        this.type = type;
        this.model = model;
        this.unmanaged = unmanaged;
        for (AdditionalStateProvider provider : providers) {
            this.addAdditionalStateProvider(provider);
        }
        this.equations = (String[])equations.clone();
        this.dimensions = (int[])dimensions.clone();
        super.resetInitialState(this.getInitialState());
    }

    private ODEStateAndDerivative getInterpolatedState(AbsoluteDate date) {
        if (date.compareTo(this.minDate.shiftedBy(-1.0)) < 0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE_BEFORE, date, this.minDate, this.maxDate, this.minDate.durationFrom(date));
        }
        if (date.compareTo(this.maxDate.shiftedBy(1.0)) > 0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE_AFTER, date, this.minDate, this.maxDate, date.durationFrom(this.maxDate));
        }
        return this.model.getInterpolatedState(date.durationFrom(this.startDate));
    }

    @Override
    protected SpacecraftState basicPropagate(AbsoluteDate date) {
        ODEStateAndDerivative os = this.getInterpolatedState(date);
        SpacecraftState state = this.mapper.mapArrayToState(this.mapper.mapDoubleToDate(os.getTime(), date), os.getPrimaryState(), os.getPrimaryDerivative(), this.type);
        for (DoubleArrayDictionary.Entry initial : this.unmanaged.getData()) {
            state = state.addAdditionalState(initial.getKey(), initial.getValue());
        }
        return state;
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        return this.basicPropagate(date).getOrbit();
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.basicPropagate(date).getMass();
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.minDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.maxDate;
    }

    @Override
    public Frame getFrame() {
        return this.mapper.getFrame();
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        super.setAttitudeProvider(attitudeProvider);
        if (this.mapper != null) {
            this.mapper.setAttitudeProvider(attitudeProvider);
        }
    }

    @Override
    public SpacecraftState getInitialState() {
        return this.updateAdditionalStates(this.basicPropagate(this.getMinDate()));
    }

    @Override
    protected SpacecraftState updateAdditionalStates(SpacecraftState original) {
        SpacecraftState updated = super.updateAdditionalStates(original);
        if (this.equations.length > 0) {
            ODEStateAndDerivative osd = this.getInterpolatedState(updated.getDate());
            double[] combinedState = osd.getSecondaryState(1);
            double[] combinedDerivative = osd.getSecondaryDerivative(1);
            int index = 0;
            for (int i = 0; i < this.equations.length; ++i) {
                double[] state = Arrays.copyOfRange(combinedState, index, index + this.dimensions[i]);
                double[] derivative = Arrays.copyOfRange(combinedDerivative, index, index + this.dimensions[i]);
                updated = updated.addAdditionalState(this.equations[i], state).addAdditionalStateDerivative(this.equations[i], derivative);
                index += this.dimensions[i];
            }
        }
        return updated;
    }
}

