/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.ode.FieldDenseOutputModel;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldOrbit;
import org.orekit.propagation.FieldAdditionalStateProvider;
import org.orekit.propagation.FieldBoundedPropagator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.analytical.FieldAbstractAnalyticalPropagator;
import org.orekit.propagation.integration.FieldStateMapper;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldArrayDictionary;
import org.orekit.utils.ParameterDriver;

public class FieldIntegratedEphemeris<T extends CalculusFieldElement<T>>
extends FieldAbstractAnalyticalPropagator<T>
implements FieldBoundedPropagator<T> {
    private static final double EXTRAPOLATION_TOLERANCE = 1.0;
    private final FieldStateMapper<T> mapper;
    private PropagationType type;
    private final FieldAbsoluteDate<T> startDate;
    private final FieldAbsoluteDate<T> minDate;
    private final FieldAbsoluteDate<T> maxDate;
    private FieldDenseOutputModel<T> model;
    private final FieldArrayDictionary<T> unmanaged;
    private final String[] equations;
    private final int[] dimensions;

    public FieldIntegratedEphemeris(FieldAbsoluteDate<T> startDate, FieldAbsoluteDate<T> minDate, FieldAbsoluteDate<T> maxDate, FieldStateMapper<T> mapper, PropagationType type, FieldDenseOutputModel<T> model, FieldArrayDictionary<T> unmanaged, List<FieldAdditionalStateProvider<T>> providers, String[] equations, int[] dimensions) {
        super(startDate.getField(), mapper.getAttitudeProvider());
        this.startDate = startDate;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.mapper = mapper;
        this.type = type;
        this.model = model;
        this.unmanaged = unmanaged;
        for (FieldAdditionalStateProvider<T> provider : providers) {
            this.addAdditionalStateProvider(provider);
        }
        this.equations = (String[])equations.clone();
        this.dimensions = (int[])dimensions.clone();
        super.resetInitialState(this.getInitialState());
    }

    private FieldODEStateAndDerivative<T> getInterpolatedState(FieldAbsoluteDate<T> date) {
        if (date.compareTo((FieldAbsoluteDate<T>)this.minDate.shiftedBy(-1.0)) < 0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE_BEFORE, date, this.minDate, this.maxDate, this.minDate.durationFrom(date).getReal());
        }
        if (date.compareTo((FieldAbsoluteDate<T>)this.maxDate.shiftedBy(1.0)) > 0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE_AFTER, date, this.minDate, this.maxDate, date.durationFrom(this.maxDate).getReal());
        }
        return this.model.getInterpolatedState(date.durationFrom(this.startDate));
    }

    @Override
    protected FieldSpacecraftState<T> basicPropagate(FieldAbsoluteDate<T> date) {
        FieldODEStateAndDerivative<T> os = this.getInterpolatedState(date);
        FieldSpacecraftState state = this.mapper.mapArrayToState(this.mapper.mapDoubleToDate(os.getTime(), date), os.getPrimaryState(), os.getPrimaryDerivative(), this.type);
        for (FieldArrayDictionary.Entry initial : this.unmanaged.getData()) {
            state = state.addAdditionalState(initial.getKey(), initial.getValue());
        }
        return state;
    }

    @Override
    protected FieldOrbit<T> propagateOrbit(FieldAbsoluteDate<T> date, T[] parameters) {
        return this.basicPropagate(date).getOrbit();
    }

    @Override
    protected T getMass(FieldAbsoluteDate<T> date) {
        return this.basicPropagate(date).getMass();
    }

    @Override
    public FieldAbsoluteDate<T> getMinDate() {
        return this.minDate;
    }

    @Override
    public FieldAbsoluteDate<T> getMaxDate() {
        return this.maxDate;
    }

    @Override
    public Frame getFrame() {
        return this.mapper.getFrame();
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected void resetIntermediateState(FieldSpacecraftState<T> state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    public FieldSpacecraftState<T> getInitialState() {
        return this.updateAdditionalStates(this.basicPropagate(this.getMinDate()));
    }

    @Override
    protected FieldSpacecraftState<T> updateAdditionalStates(FieldSpacecraftState<T> original) {
        FieldSpacecraftState updated = super.updateAdditionalStates(original);
        if (this.equations.length > 0) {
            FieldODEStateAndDerivative<T> osd = this.getInterpolatedState(updated.getDate());
            CalculusFieldElement[] combinedState = osd.getSecondaryState(1);
            CalculusFieldElement[] combinedDerivative = osd.getSecondaryDerivative(1);
            int index = 0;
            for (int i = 0; i < this.equations.length; ++i) {
                CalculusFieldElement[] state = Arrays.copyOfRange(combinedState, index, index + this.dimensions[i]);
                CalculusFieldElement[] derivative = Arrays.copyOfRange(combinedDerivative, index, index + this.dimensions[i]);
                updated = updated.addAdditionalState(this.equations[i], state).addAdditionalStateDerivative(this.equations[i], derivative);
                index += this.dimensions[i];
            }
        }
        return updated;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

