/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldAbsolutePVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversProvider;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public abstract class AbstractGradientConverter {
    private final int freeStateParameters;
    private final List<FieldSpacecraftState<Gradient>> gStates;

    protected AbstractGradientConverter(int freeStateParameters) {
        this.freeStateParameters = freeStateParameters;
        this.gStates = new ArrayList<FieldSpacecraftState<Gradient>>();
    }

    public int getFreeStateParameters() {
        return this.freeStateParameters;
    }

    protected void initStates(FieldSpacecraftState<Gradient> zeroParametersState) {
        this.gStates.clear();
        this.gStates.add(zeroParametersState);
    }

    protected Gradient extend(Gradient original, int freeParameters) {
        double[] originalDerivatives = original.getGradient();
        double[] extendedDerivatives = new double[freeParameters];
        System.arraycopy(originalDerivatives, 0, extendedDerivatives, 0, originalDerivatives.length);
        return new Gradient(original.getValue(), extendedDerivatives);
    }

    protected FieldAbsoluteDate<Gradient> extend(FieldAbsoluteDate<Gradient> original, int freeParameters) {
        AbsoluteDate date = original.toAbsoluteDate();
        Gradient gradient = original.durationFrom(date);
        return new FieldAbsoluteDate<Gradient>(date, this.extend(gradient, freeParameters));
    }

    protected FieldVector3D<Gradient> extend(FieldVector3D<Gradient> original, int freeParameters) {
        return new FieldVector3D((CalculusFieldElement)this.extend((Gradient)original.getX(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getY(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getZ(), freeParameters));
    }

    protected FieldRotation<Gradient> extend(FieldRotation<Gradient> original, int freeParameters) {
        return new FieldRotation((CalculusFieldElement)this.extend((Gradient)original.getQ0(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getQ1(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getQ2(), freeParameters), (CalculusFieldElement)this.extend((Gradient)original.getQ3(), freeParameters), false);
    }

    protected static FieldSpacecraftState<Gradient> buildBasicGradientSpacecraftState(SpacecraftState state, int freeStateParameters, AttitudeProvider provider) {
        FieldAbsolutePVCoordinates gAbsolutePV;
        FieldCartesianOrbit<Gradient> gOrbit;
        GradientField field = GradientField.getField((int)freeStateParameters);
        Vector3D pos = state.getPosition();
        FieldVector3D posG = new FieldVector3D((CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)0, (double)pos.getX()), (CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)1, (double)pos.getY()), (CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)2, (double)pos.getZ()));
        Vector3D vel = state.getPVCoordinates().getVelocity();
        FieldVector3D velG = freeStateParameters > 3 ? new FieldVector3D((CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)3, (double)vel.getX()), (CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)4, (double)vel.getY()), (CalculusFieldElement)Gradient.variable((int)freeStateParameters, (int)5, (double)vel.getZ())) : new FieldVector3D((Field)field, vel);
        Vector3D acc = state.getPVCoordinates().getAcceleration();
        FieldVector3D accG = new FieldVector3D((Field)field, acc);
        Gradient gMass = Gradient.constant((int)freeStateParameters, (double)state.getMass());
        TimeStampedFieldPVCoordinates timeStampedFieldPVCoordinates = new TimeStampedFieldPVCoordinates(state.getDate(), posG, velG, accG);
        if (state.isOrbitDefined()) {
            Gradient gMu = Gradient.constant((int)freeStateParameters, (double)state.getMu());
            gOrbit = new FieldCartesianOrbit<Gradient>(timeStampedFieldPVCoordinates, state.getFrame(), gMu);
            gAbsolutePV = null;
        } else {
            gOrbit = null;
            gAbsolutePV = new FieldAbsolutePVCoordinates(state.getFrame(), timeStampedFieldPVCoordinates);
        }
        FieldAttitude<Object> gAttitude = freeStateParameters > 3 ? provider.getAttitude(state.isOrbitDefined() ? gOrbit : gAbsolutePV, timeStampedFieldPVCoordinates.getDate(), state.getFrame()) : new FieldAttitude(field, state.getAttitude());
        if (state.isOrbitDefined()) {
            return new FieldSpacecraftState<Gradient>(gOrbit, gAttitude, gMass);
        }
        return new FieldSpacecraftState<Gradient>(gAbsolutePV, gAttitude, gMass);
    }

    public FieldSpacecraftState<Gradient> getState(ParameterDriversProvider parametricModel) {
        int nbParams = 0;
        for (ParameterDriver driver : parametricModel.getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            nbParams += driver.getNbOfValues();
        }
        while (this.gStates.size() < nbParams + 1) {
            this.gStates.add(null);
        }
        if (this.gStates.get(nbParams) == null) {
            FieldOrbit<Gradient> orbit;
            int freeParameters = this.freeStateParameters + nbParams;
            FieldSpacecraftState<Gradient> s0 = this.gStates.get(0);
            AbsoluteDate date = s0.getDate().toAbsoluteDate();
            TimeStampedFieldAngularCoordinates<Gradient> ac0 = s0.getAttitude().getOrientation();
            FieldAttitude<Gradient> gAttitude = new FieldAttitude<Gradient>(s0.getAttitude().getReferenceFrame(), new TimeStampedFieldAngularCoordinates<Gradient>(date, this.extend(ac0.getRotation(), freeParameters), this.extend(ac0.getRotationRate(), freeParameters), this.extend(ac0.getRotationAcceleration(), freeParameters)));
            Gradient gMass = this.extend(s0.getMass(), freeParameters);
            TimeStampedFieldPVCoordinates<Gradient> pv0 = s0.getPVCoordinates();
            TimeStampedFieldPVCoordinates<Gradient> timeStampedFieldPVCoordinates = new TimeStampedFieldPVCoordinates<Gradient>(date, this.extend(pv0.getPosition(), freeParameters), this.extend(pv0.getVelocity(), freeParameters), this.extend(pv0.getAcceleration(), freeParameters));
            FieldSpacecraftState<Gradient> spacecraftState = s0.isOrbitDefined() ? ((orbit = s0.getOrbit()).getType().equals((Object)OrbitType.EQUINOCTIAL) ? new FieldSpacecraftState<Gradient>(new FieldEquinoctialOrbit<Gradient>(this.extend(orbit.getA(), freeParameters), this.extend(orbit.getEquinoctialEx(), freeParameters), this.extend(orbit.getEquinoctialEy(), freeParameters), this.extend(orbit.getHx(), freeParameters), this.extend(orbit.getHy(), freeParameters), this.extend(orbit.getLM(), freeParameters), PositionAngleType.MEAN, s0.getFrame(), this.extend(s0.getDate(), freeParameters), this.extend(s0.getMu(), freeParameters)), gAttitude, gMass) : new FieldSpacecraftState<Gradient>(new FieldCartesianOrbit<Gradient>(timeStampedFieldPVCoordinates, s0.getFrame(), this.extend(s0.getMu(), freeParameters)), gAttitude, gMass)) : new FieldSpacecraftState<Gradient>(new FieldAbsolutePVCoordinates<Gradient>(s0.getFrame(), timeStampedFieldPVCoordinates), gAttitude, gMass);
            this.gStates.set(nbParams, spacecraftState);
        }
        return this.gStates.get(nbParams);
    }

    public Gradient[] getParameters(FieldSpacecraftState<Gradient> state, ParameterDriversProvider parametricModel) {
        int freeParameters = state.getMass().getFreeParameters();
        List<ParameterDriver> drivers = parametricModel.getParametersDrivers();
        int sizeDrivers = 0;
        for (ParameterDriver driver : drivers) {
            sizeDrivers += driver.getNbOfValues();
        }
        Gradient[] parameters = new Gradient[sizeDrivers];
        int index = this.freeStateParameters;
        int i = 0;
        for (ParameterDriver driver : drivers) {
            for (TimeSpanMap.Span<Double> span = driver.getValueSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameters[i++] = driver.isSelected() ? Gradient.variable((int)freeParameters, (int)index++, (double)span.getData()) : Gradient.constant((int)freeParameters, (double)span.getData());
            }
        }
        return parameters;
    }

    public Gradient[] getParametersAtStateDate(FieldSpacecraftState<Gradient> state, ParameterDriversProvider parametricModel) {
        int freeParameters = state.getMass().getFreeParameters();
        List<ParameterDriver> drivers = parametricModel.getParametersDrivers();
        Gradient[] parameters = new Gradient[drivers.size()];
        int index = this.freeStateParameters;
        int i = 0;
        for (ParameterDriver driver : drivers) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                if (span.getData().equals(driver.getNameSpan(state.getDate().toAbsoluteDate()))) {
                    parameters[i++] = driver.isSelected() ? Gradient.variable((int)freeParameters, (int)index, (double)driver.getValue(state.getDate().toAbsoluteDate())) : Gradient.constant((int)freeParameters, (double)driver.getValue(state.getDate().toAbsoluteDate()));
                }
                index = driver.isSelected() ? index + 1 : index;
            }
        }
        return parameters;
    }
}

