/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events.intervals;

import org.hipparchus.util.FastMath;
import org.orekit.frames.TopocentricFrame;
import org.orekit.frames.Transform;
import org.orekit.propagation.events.AdaptableInterval;

public class ElevationDetectionAdaptableIntervalFactory {
    public static final double DEFAULT_ELEVATION_SWITCH = FastMath.toRadians((double)-5.0);

    private ElevationDetectionAdaptableIntervalFactory() {
    }

    public static AdaptableInterval getAdaptableInterval(TopocentricFrame topo, double elevationSwitch, double fineCheckInterval) {
        return state -> {
            double elevation = topo.getElevation(state.getPosition(), state.getFrame(), state.getDate());
            if (elevation <= elevationSwitch) {
                Transform topoToInertial = topo.getTransformTo(state.getFrame(), state.getDate());
                double topoAngularVelocity = topoToInertial.getAngular().getRotationRate().getNorm();
                double e = state.getE();
                double rp = state.getA() * (1.0 - e);
                double vp = FastMath.sqrt((double)(state.getMu() * (1.0 + e) / rp));
                double rateP = vp / rp;
                double maxElevationRate = topoAngularVelocity + rateP;
                return FastMath.max((double)fineCheckInterval, (double)((elevationSwitch - elevation) / maxElevationRate));
            }
            return fineCheckInterval;
        };
    }
}

