/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events.intervals;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.events.AdaptableInterval;

public class ApsideDetectionAdaptableIntervalFactory {
    private ApsideDetectionAdaptableIntervalFactory() {
    }

    public static AdaptableInterval getForwardApsideDetectionAdaptableInterval() {
        return state -> {
            Orbit orbit = state.getOrbit();
            KeplerianOrbit keplerianOrbit = ApsideDetectionAdaptableIntervalFactory.convertOrbitIntoKeplerianOne(orbit);
            double meanMotion = keplerianOrbit.getKeplerianMeanMotion();
            double meanAnomaly = keplerianOrbit.getMeanAnomaly();
            double durationToNextPeriapsis = ApsideDetectionAdaptableIntervalFactory.computeKeplerianDurationToNextPeriapsis(meanAnomaly, meanMotion);
            double durationToNextApoapsis = ApsideDetectionAdaptableIntervalFactory.computeKeplerianDurationToNextApoapsis(meanAnomaly, meanMotion);
            return FastMath.min((double)durationToNextPeriapsis, (double)durationToNextApoapsis);
        };
    }

    public static AdaptableInterval getBackwardApsideDetectionAdaptableInterval() {
        return state -> {
            Orbit orbit = state.getOrbit();
            KeplerianOrbit keplerianOrbit = ApsideDetectionAdaptableIntervalFactory.convertOrbitIntoKeplerianOne(orbit);
            double meanMotion = keplerianOrbit.getKeplerianMeanMotion();
            double meanAnomaly = keplerianOrbit.getMeanAnomaly();
            double durationFromPreviousPeriapsis = ApsideDetectionAdaptableIntervalFactory.computeKeplerianDurationFromPreviousPeriapsis(meanAnomaly, meanMotion);
            double durationFromPreviousApoapsis = ApsideDetectionAdaptableIntervalFactory.computeKeplerianDurationFromPreviousApoapsis(meanAnomaly, meanMotion);
            return FastMath.min((double)durationFromPreviousApoapsis, (double)durationFromPreviousPeriapsis);
        };
    }

    public static AdaptableInterval getForwardPeriapsisDetectionAdaptableInterval() {
        return state -> {
            Orbit orbit = state.getOrbit();
            KeplerianOrbit keplerianOrbit = ApsideDetectionAdaptableIntervalFactory.convertOrbitIntoKeplerianOne(orbit);
            double meanMotion = keplerianOrbit.getKeplerianMeanMotion();
            double meanAnomaly = keplerianOrbit.getMeanAnomaly();
            return ApsideDetectionAdaptableIntervalFactory.computeKeplerianDurationToNextPeriapsis(meanAnomaly, meanMotion);
        };
    }

    public static AdaptableInterval getBackwardPeriapsisDetectionAdaptableInterval() {
        return state -> {
            Orbit orbit = state.getOrbit();
            KeplerianOrbit keplerianOrbit = ApsideDetectionAdaptableIntervalFactory.convertOrbitIntoKeplerianOne(orbit);
            double meanMotion = keplerianOrbit.getKeplerianMeanMotion();
            double meanAnomaly = keplerianOrbit.getMeanAnomaly();
            return ApsideDetectionAdaptableIntervalFactory.computeKeplerianDurationFromPreviousPeriapsis(meanAnomaly, meanMotion);
        };
    }

    public static AdaptableInterval getForwardApoapsisDetectionAdaptableInterval() {
        return state -> {
            Orbit orbit = state.getOrbit();
            KeplerianOrbit keplerianOrbit = ApsideDetectionAdaptableIntervalFactory.convertOrbitIntoKeplerianOne(orbit);
            double meanMotion = keplerianOrbit.getKeplerianMeanMotion();
            double meanAnomaly = keplerianOrbit.getMeanAnomaly();
            return ApsideDetectionAdaptableIntervalFactory.computeKeplerianDurationToNextApoapsis(meanAnomaly, meanMotion);
        };
    }

    public static AdaptableInterval getBackwardApoapsisDetectionAdaptableInterval() {
        return state -> {
            Orbit orbit = state.getOrbit();
            KeplerianOrbit keplerianOrbit = ApsideDetectionAdaptableIntervalFactory.convertOrbitIntoKeplerianOne(orbit);
            double meanMotion = keplerianOrbit.getKeplerianMeanMotion();
            double meanAnomaly = keplerianOrbit.getMeanAnomaly();
            return ApsideDetectionAdaptableIntervalFactory.computeKeplerianDurationFromPreviousApoapsis(meanAnomaly, meanMotion);
        };
    }

    private static KeplerianOrbit convertOrbitIntoKeplerianOne(Orbit orbit) {
        return (KeplerianOrbit)OrbitType.KEPLERIAN.convertType(orbit);
    }

    private static double computeKeplerianDurationToNextPeriapsis(double meanAnomaly, double meanMotion) {
        double normalizedMeanAnomaly = MathUtils.normalizeAngle((double)meanAnomaly, (double)Math.PI);
        return (Math.PI * 2 - normalizedMeanAnomaly) / meanMotion;
    }

    public static double computeKeplerianDurationFromPreviousPeriapsis(double meanAnomaly, double meanMotion) {
        double normalizedMeanAnomaly = MathUtils.normalizeAngle((double)meanAnomaly, (double)Math.PI);
        return normalizedMeanAnomaly / meanMotion;
    }

    private static double computeKeplerianDurationToNextApoapsis(double meanAnomaly, double meanMotion) {
        double normalizedMeanAnomaly = MathUtils.normalizeAngle((double)meanAnomaly, (double)(Math.PI * 2));
        return (Math.PI * 3 - normalizedMeanAnomaly) / meanMotion;
    }

    public static double computeKeplerianDurationFromPreviousApoapsis(double meanAnomaly, double meanMotion) {
        double normalizedMeanAnomaly = MathUtils.normalizeAngle((double)meanAnomaly, (double)(Math.PI * 2));
        return (normalizedMeanAnomaly - Math.PI) / meanMotion;
    }
}

