/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.ode.events.Action;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;

public class RecordAndContinue
implements EventHandler {
    private final List<Event> events;

    public RecordAndContinue() {
        this(new ArrayList<Event>());
    }

    public RecordAndContinue(List<Event> events) {
        this.events = events;
    }

    public List<Event> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public void clear() {
        this.events.clear();
    }

    @Override
    public Action eventOccurred(SpacecraftState s, EventDetector detector, boolean increasing) {
        this.events.add(new Event(detector, s, increasing));
        return Action.CONTINUE;
    }

    public static class Event {
        private final SpacecraftState state;
        private final EventDetector detector;
        private final boolean increasing;

        private Event(EventDetector detector, SpacecraftState state, boolean increasing) {
            this.detector = detector;
            this.state = state;
            this.increasing = increasing;
        }

        public EventDetector getDetector() {
            return this.detector;
        }

        public boolean isIncreasing() {
            return this.increasing;
        }

        public SpacecraftState getState() {
            return this.state;
        }

        public String toString() {
            return "Event{state=" + this.state + ", increasing=" + this.increasing + ", detector=" + this.detector + '}';
        }
    }
}

