/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events.handlers;

import org.hipparchus.ode.events.Action;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;

public class RecallLastOccurrence
implements EventHandler {
    private final EventHandler wrappedHandler;
    private AbsoluteDate lastOccurrence;

    public RecallLastOccurrence(EventHandler wrappedHandler) {
        this.wrappedHandler = wrappedHandler;
    }

    public AbsoluteDate getLastOccurrence() {
        return this.lastOccurrence;
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target, EventDetector detector) {
        boolean isForward = target.isAfter(initialState.getDate());
        this.lastOccurrence = isForward ? AbsoluteDate.PAST_INFINITY : AbsoluteDate.FUTURE_INFINITY;
        this.wrappedHandler.init(initialState, target, detector);
    }

    @Override
    public Action eventOccurred(SpacecraftState s, EventDetector detector, boolean increasing) {
        this.lastOccurrence = s.getDate();
        return this.wrappedHandler.eventOccurred(s, detector, increasing);
    }

    @Override
    public SpacecraftState resetState(EventDetector detector, SpacecraftState oldState) {
        return this.wrappedHandler.resetState(detector, oldState);
    }

    @Override
    public void finish(SpacecraftState finalState, EventDetector detector) {
        this.wrappedHandler.finish(finalState, detector);
    }
}

