/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.ode.events.Action;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;

public class FieldRecordAndContinue<T extends CalculusFieldElement<T>>
implements FieldEventHandler<T> {
    private final List<Event<T>> events;

    public FieldRecordAndContinue() {
        this(new ArrayList<Event<T>>());
    }

    public FieldRecordAndContinue(List<Event<T>> events) {
        this.events = events;
    }

    public List<Event<T>> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public void clear() {
        this.events.clear();
    }

    @Override
    public Action eventOccurred(FieldSpacecraftState<T> s, FieldEventDetector<T> detector, boolean increasing) {
        this.events.add(new Event(detector, s, increasing));
        return Action.CONTINUE;
    }

    public static class Event<T extends CalculusFieldElement<T>> {
        private final FieldSpacecraftState<T> state;
        private final FieldEventDetector<T> detector;
        private final boolean increasing;

        private Event(FieldEventDetector<T> detector, FieldSpacecraftState<T> state, boolean increasing) {
            this.detector = detector;
            this.state = state;
            this.increasing = increasing;
        }

        public FieldEventDetector<T> getDetector() {
            return this.detector;
        }

        public boolean isIncreasing() {
            return this.increasing;
        }

        public FieldSpacecraftState<T> getState() {
            return this.state;
        }

        public String toString() {
            return "Event{state=" + this.state + ", increasing=" + this.increasing + ", detector=" + this.detector + '}';
        }
    }
}

