/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events.handlers;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.events.Action;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.events.handlers.FieldEventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;

public class FieldRecallLastOccurrence<T extends CalculusFieldElement<T>>
implements FieldEventHandler<T> {
    private final FieldEventHandler<T> wrappedHandler;
    private FieldAbsoluteDate<T> lastOccurrence;

    public FieldRecallLastOccurrence(FieldEventHandler<T> wrappedHandler) {
        this.wrappedHandler = wrappedHandler;
    }

    public FieldAbsoluteDate<T> getLastOccurrence() {
        return this.lastOccurrence;
    }

    @Override
    public void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target, FieldEventDetector<T> detector) {
        boolean isForward = target.isAfter(initialState.getDate());
        Field<T> field = target.getField();
        AbsoluteDate date = isForward ? AbsoluteDate.PAST_INFINITY : AbsoluteDate.FUTURE_INFINITY;
        this.lastOccurrence = new FieldAbsoluteDate<T>(field, date);
        this.wrappedHandler.init(initialState, target, detector);
    }

    @Override
    public Action eventOccurred(FieldSpacecraftState<T> s, FieldEventDetector<T> detector, boolean increasing) {
        this.lastOccurrence = s.getDate();
        return this.wrappedHandler.eventOccurred(s, detector, increasing);
    }

    @Override
    public FieldSpacecraftState<T> resetState(FieldEventDetector<T> detector, FieldSpacecraftState<T> oldState) {
        return this.wrappedHandler.resetState(detector, oldState);
    }

    @Override
    public void finish(FieldSpacecraftState<T> finalState, FieldEventDetector<T> detector) {
        this.wrappedHandler.finish(finalState, detector);
    }
}

