/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hipparchus.ode.events.Action;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;

public class EventMultipleHandler
implements EventHandler {
    private List<EventHandler> handlers = new ArrayList<EventHandler>();
    private List<EventHandler> resetStateHandlers = new ArrayList<EventHandler>();

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target, EventDetector detector) {
        this.handlers.forEach(handler -> handler.init(initialState, target, detector));
    }

    @Override
    public Action eventOccurred(SpacecraftState s, EventDetector detector, boolean increasing) {
        Map actions = this.handlers.stream().collect(Collectors.toMap(Function.identity(), handler -> handler.eventOccurred(s, detector, increasing)));
        if (actions.containsValue(Action.STOP)) {
            return Action.STOP;
        }
        if (actions.containsValue(Action.RESET_STATE)) {
            this.resetStateHandlers = actions.entrySet().stream().filter(entry -> Action.RESET_STATE.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
            return Action.RESET_STATE;
        }
        if (actions.containsValue(Action.RESET_DERIVATIVES)) {
            return Action.RESET_DERIVATIVES;
        }
        if (actions.containsValue(Action.RESET_EVENTS)) {
            return Action.RESET_EVENTS;
        }
        return Action.CONTINUE;
    }

    @Override
    public SpacecraftState resetState(EventDetector detector, SpacecraftState oldState) {
        SpacecraftState newState = oldState;
        for (EventHandler handler : this.resetStateHandlers) {
            newState = handler.resetState(detector, newState);
        }
        return newState;
    }

    @Override
    public void finish(SpacecraftState finalState, EventDetector detector) {
        for (EventHandler handler : this.handlers) {
            handler.finish(finalState, detector);
        }
    }

    public EventMultipleHandler addHandler(EventHandler handler) {
        this.handlers.add(handler);
        return this;
    }

    @SafeVarargs
    public final EventMultipleHandler addHandlers(EventHandler ... newHandlers) {
        Arrays.stream(newHandlers).forEach(this::addHandler);
        return this;
    }

    public void setHandlers(List<EventHandler> newHandlers) {
        this.handlers = newHandlers;
    }

    public List<EventHandler> getHandlers() {
        return this.handlers;
    }
}

