/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;

enum Transformer {
    UNINITIALIZED{

        @Override
        protected double transformed(double g) {
            return 0.0;
        }

        @Override
        protected <T extends CalculusFieldElement<T>> T transformed(T g) {
            return (T)((CalculusFieldElement)g.getField().getZero());
        }
    }
    ,
    PLUS{

        @Override
        protected double transformed(double g) {
            return g;
        }

        @Override
        protected <T extends CalculusFieldElement<T>> T transformed(T g) {
            return g;
        }
    }
    ,
    MINUS{

        @Override
        protected double transformed(double g) {
            return -g;
        }

        @Override
        protected <T extends CalculusFieldElement<T>> T transformed(T g) {
            return (T)((CalculusFieldElement)g.negate());
        }
    }
    ,
    MIN{

        @Override
        protected double transformed(double g) {
            return FastMath.min((double)(-Precision.SAFE_MIN), (double)FastMath.min((double)(-g), (double)g));
        }

        @Override
        protected <T extends CalculusFieldElement<T>> T transformed(T g) {
            CalculusFieldElement zero = (CalculusFieldElement)g.getField().getZero();
            return (T)FastMath.min((CalculusFieldElement)((CalculusFieldElement)zero.newInstance(-Precision.SAFE_MIN)), (CalculusFieldElement)FastMath.min((CalculusFieldElement)((CalculusFieldElement)g.negate()), g));
        }
    }
    ,
    MAX{

        @Override
        protected double transformed(double g) {
            return FastMath.max((double)Precision.SAFE_MIN, (double)FastMath.max((double)(-g), (double)g));
        }

        @Override
        protected <T extends CalculusFieldElement<T>> T transformed(T g) {
            CalculusFieldElement zero = (CalculusFieldElement)g.getField().getZero();
            return (T)FastMath.max((CalculusFieldElement)((CalculusFieldElement)zero.newInstance(Precision.SAFE_MIN)), (CalculusFieldElement)FastMath.max((CalculusFieldElement)((CalculusFieldElement)g.negate()), g));
        }
    };


    protected abstract double transformed(double var1);

    protected abstract <T extends CalculusFieldElement<T>> T transformed(T var1);
}

