/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnEvent;
import org.orekit.utils.PVCoordinatesProvider;

public class RelativeDistanceDetector
extends AbstractDetector<RelativeDistanceDetector> {
    private final PVCoordinatesProvider secondaryPVProvider;
    private final double distanceThreshold;

    public RelativeDistanceDetector(PVCoordinatesProvider secondaryPVProvider, double distanceThreshold) {
        this(EventDetectionSettings.getDefaultEventDetectionSettings(), new StopOnEvent(), secondaryPVProvider, distanceThreshold);
    }

    protected RelativeDistanceDetector(EventDetectionSettings detectionSettings, EventHandler handler, PVCoordinatesProvider secondaryPVProvider, double distanceThreshold) {
        super(detectionSettings, handler);
        this.secondaryPVProvider = secondaryPVProvider;
        this.distanceThreshold = distanceThreshold;
    }

    @Deprecated
    protected RelativeDistanceDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, PVCoordinatesProvider secondaryPVProvider, double distanceThreshold) {
        this(new EventDetectionSettings(maxCheck, threshold, maxIter), handler, secondaryPVProvider, distanceThreshold);
    }

    @Override
    public double g(SpacecraftState s) {
        Vector3D secondaryPosition = this.getSecondaryPVProvider().getPosition(s.getDate(), s.getFrame());
        double relativeDistance = s.getPosition().subtract((Vector)secondaryPosition).getNorm();
        return relativeDistance - this.distanceThreshold;
    }

    @Override
    protected RelativeDistanceDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new RelativeDistanceDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.secondaryPVProvider, this.distanceThreshold);
    }

    public PVCoordinatesProvider getSecondaryPVProvider() {
        return this.secondaryPVProvider;
    }

    public double getDistanceThreshold() {
        return this.distanceThreshold;
    }
}

