/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.util.function.Function;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BracketingNthOrderBrentSolver;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.CircularOrbit;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnEvent;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeSpanMap;

public class PositionAngleDetector
extends AbstractDetector<PositionAngleDetector> {
    private final OrbitType orbitType;
    private final PositionAngleType positionAngleType;
    private final double angle;
    private final Function<Orbit, Double> positionAngleExtractor;
    private TimeSpanMap<OffsetEstimator> offsetEstimators;

    public PositionAngleDetector(OrbitType orbitType, PositionAngleType positionAngleType, double angle) throws OrekitIllegalArgumentException {
        this(600.0, 1.0E-6, orbitType, positionAngleType, angle);
    }

    public PositionAngleDetector(double maxCheck, double threshold, OrbitType orbitType, PositionAngleType positionAngleType, double angle) throws OrekitIllegalArgumentException {
        this(AdaptableInterval.of(maxCheck), threshold, 100, new StopOnEvent(), orbitType, positionAngleType, angle);
    }

    protected PositionAngleDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, OrbitType orbitType, PositionAngleType positionAngleType, double angle) throws OrekitIllegalArgumentException {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.orbitType = orbitType;
        this.positionAngleType = positionAngleType;
        this.angle = angle;
        this.offsetEstimators = null;
        switch (orbitType) {
            case KEPLERIAN: {
                this.positionAngleExtractor = o -> ((KeplerianOrbit)orbitType.convertType((Orbit)o)).getAnomaly(positionAngleType);
                break;
            }
            case CIRCULAR: {
                this.positionAngleExtractor = o -> ((CircularOrbit)orbitType.convertType((Orbit)o)).getAlpha(positionAngleType);
                break;
            }
            case EQUINOCTIAL: {
                this.positionAngleExtractor = o -> ((EquinoctialOrbit)orbitType.convertType((Orbit)o)).getL(positionAngleType);
                break;
            }
            default: {
                String sep = ", ";
                throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_TYPE_NOT_ALLOWED, new Object[]{orbitType, (Object)((Object)OrbitType.KEPLERIAN) + ", " + (Object)((Object)OrbitType.CIRCULAR) + ", " + (Object)((Object)OrbitType.EQUINOCTIAL)});
            }
        }
    }

    @Override
    protected PositionAngleDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new PositionAngleDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.orbitType, this.positionAngleType, this.angle);
    }

    public OrbitType getOrbitType() {
        return this.orbitType;
    }

    public PositionAngleType getPositionAngleType() {
        return this.positionAngleType;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        super.init(s0, t);
        this.offsetEstimators = new TimeSpanMap<OffsetEstimator>(new OffsetEstimator(s0.getOrbit(), 1.0));
    }

    @Override
    public double g(SpacecraftState s) {
        Orbit orbit = s.getOrbit();
        OffsetEstimator estimator = this.offsetEstimators.get(s.getDate());
        double delta = estimator.delta(orbit);
        while (FastMath.abs((double)delta) >= 3.5) {
            AbsoluteDate handover = estimator.dateForOffset(FastMath.copySign((double)Math.PI, (double)delta), orbit);
            estimator = new OffsetEstimator(orbit, delta);
            delta = estimator.delta(orbit);
            if (this.isForward()) {
                this.offsetEstimators.addValidAfter(estimator, handover.getDate(), false);
                continue;
            }
            this.offsetEstimators.addValidBefore(estimator, handover.getDate(), false);
        }
        return delta;
    }

    private class OffsetEstimator {
        private final double target;
        private final double sign;
        private final double r0;
        private final double r1;
        private final AbsoluteDate t0;

        OffsetEstimator(Orbit orbit, double currentSign) {
            this.r0 = (Double)PositionAngleDetector.this.positionAngleExtractor.apply(orbit);
            this.target = MathUtils.normalizeAngle((double)PositionAngleDetector.this.angle, (double)this.r0);
            this.sign = FastMath.copySign((double)1.0, (double)((this.r0 - this.target) * currentSign));
            this.r1 = orbit.getKeplerianMeanMotion();
            this.t0 = orbit.getDate();
        }

        public double delta(Orbit orbit) {
            double rawAngle = (Double)PositionAngleDetector.this.positionAngleExtractor.apply(orbit);
            double linearReference = this.r0 + this.r1 * orbit.getDate().durationFrom(this.t0);
            double linearizedAngle = MathUtils.normalizeAngle((double)rawAngle, (double)linearReference);
            return this.sign * (linearizedAngle - this.target);
        }

        public AbsoluteDate dateForOffset(double offset, Orbit orbit) {
            double searchSup;
            double searchInf;
            double period = orbit.getKeplerianPeriod();
            double delta0 = this.delta(orbit);
            if ((delta0 - offset) * this.sign >= 0.0) {
                searchInf = -period;
                searchSup = 0.0;
            } else {
                searchInf = 0.0;
                searchSup = period;
            }
            BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(PositionAngleDetector.this.getThreshold(), 5);
            UnivariateFunction f = dt -> this.delta(orbit.shiftedBy(dt)) - offset;
            double root = solver.solve(PositionAngleDetector.this.getMaxIterationCount(), f, searchInf, searchSup);
            return orbit.getDate().shiftedBy(root);
        }
    }
}

