/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.data.DataContext;
import org.orekit.models.earth.GeoMagneticField;
import org.orekit.models.earth.GeoMagneticFieldFactory;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.AdaptableInterval;
import org.orekit.propagation.events.EventDetectionSettings;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.UTCScale;

public class MagneticFieldDetector
extends AbstractDetector<MagneticFieldDetector> {
    private final double limit;
    private final boolean atSeaLevel;
    private GeoMagneticField field;
    private double currentYear;
    private final GeoMagneticFieldFactory.FieldModel model;
    private final OneAxisEllipsoid body;
    private final DataContext dataContext;

    @DefaultDataContext
    public MagneticFieldDetector(double limit, GeoMagneticFieldFactory.FieldModel model, OneAxisEllipsoid body) {
        this(600.0, 1.0E-6, limit, model, body, false);
    }

    @DefaultDataContext
    public MagneticFieldDetector(double limit, GeoMagneticFieldFactory.FieldModel model, OneAxisEllipsoid body, boolean atSeaLevel) {
        this(600.0, 1.0E-6, limit, model, body, atSeaLevel);
    }

    @DefaultDataContext
    public MagneticFieldDetector(double maxCheck, double threshold, double limit, GeoMagneticFieldFactory.FieldModel model, OneAxisEllipsoid body, boolean atSeaLevel) {
        this(maxCheck, threshold, limit, model, body, atSeaLevel, DataContext.getDefault());
    }

    public MagneticFieldDetector(double maxCheck, double threshold, double limit, GeoMagneticFieldFactory.FieldModel model, OneAxisEllipsoid body, boolean atSeaLevel, DataContext dataContext) {
        this(AdaptableInterval.of(maxCheck), threshold, 100, new StopOnIncreasing(), limit, model, body, atSeaLevel, dataContext);
    }

    protected MagneticFieldDetector(AdaptableInterval maxCheck, double threshold, int maxIter, EventHandler handler, double limit, GeoMagneticFieldFactory.FieldModel model, OneAxisEllipsoid body, boolean atSeaLevel, DataContext dataContext) {
        super(new EventDetectionSettings(maxCheck, threshold, maxIter), handler);
        this.limit = limit;
        this.model = model;
        this.body = body;
        this.atSeaLevel = atSeaLevel;
        this.dataContext = dataContext;
    }

    @Override
    protected MagneticFieldDetector create(AdaptableInterval newMaxCheck, double newThreshold, int newMaxIter, EventHandler newHandler) {
        return new MagneticFieldDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.limit, this.model, this.body, this.atSeaLevel, this.dataContext);
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) {
        super.init(s0, t);
        UTCScale utc = this.dataContext.getTimeScales().getUTC();
        this.currentYear = s0.getDate().getComponents(utc).getDate().getYear();
        this.field = this.dataContext.getGeoMagneticFields().getField(this.model, this.currentYear);
    }

    @Override
    public double g(SpacecraftState s) {
        UTCScale utc = this.dataContext.getTimeScales().getUTC();
        if ((double)s.getDate().getComponents(utc).getDate().getYear() != this.currentYear) {
            this.currentYear = s.getDate().getComponents(utc).getDate().getYear();
            this.field = this.dataContext.getGeoMagneticFields().getField(this.model, this.currentYear);
        }
        GeodeticPoint geoPoint = this.body.transform(s.getPosition(), s.getFrame(), s.getDate());
        double altitude = this.atSeaLevel ? 0.0 : geoPoint.getAltitude();
        double value = this.field.calculateField(geoPoint.getLatitude(), geoPoint.getLongitude(), altitude).getTotalIntensity();
        return value - this.limit;
    }
}

